/*
 * Decompiled with CFR 0.152.
 */
package cofh.world;

import cofh.CoFHWorld;
import cofh.api.world.IFeatureGenerator;
import cofh.api.world.IFeatureHandler;
import cofh.util.ChunkCoord;
import cofh.world.TickHandlerWorld;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.world.ChunkDataEvent;

public class WorldHandler
implements IWorldGenerator,
IFeatureHandler {
    private static List features = new ArrayList();
    private static HashSet featureNames = new HashSet();
    private static HashSet vanillaGenEvents = new HashSet();
    private static HashSet dimensionBlacklist = new HashSet();
    public static WorldHandler instance;

    @ForgeSubscribe
    public void handleChunkSaveEvent(ChunkDataEvent.Save event) {
        NBTTagCompound tag = new NBTTagCompound();
        if (CoFHWorld.retroFlatBedrock && CoFHWorld.genFlatBedrock) {
            tag.func_74757_a("Bedrock", true);
        }
        if (CoFHWorld.retroOreGeneration) {
            tag.func_74757_a("Ores", true);
        }
        event.getData().func_74782_a("CoFHWorld", (NBTBase)tag);
    }

    @ForgeSubscribe
    public void handleChunkLoadEvent(ChunkDataEvent.Load event) {
        int dim = event.world.field_73011_w.field_76574_g;
        if (dimensionBlacklist.contains(dim)) {
            return;
        }
        boolean bedrock = false;
        boolean ores = false;
        boolean regen = false;
        NBTTagCompound tag = (NBTTagCompound)event.getData().func_74781_a("CoFHWorld");
        if (tag != null) {
            bedrock = !tag.func_74764_b("Bedrock") && CoFHWorld.retroFlatBedrock && CoFHWorld.genFlatBedrock;
            ores = !tag.func_74764_b("Ores") && CoFHWorld.retroOreGeneration;
        }
        ChunkCoord cCoord = new ChunkCoord(event.getChunk());
        if (tag == null && (CoFHWorld.retroFlatBedrock && CoFHWorld.genFlatBedrock || CoFHWorld.retroOreGeneration)) {
            regen = true;
        }
        if (bedrock) {
            CoFHWorld.log.log(Level.INFO, "Retroactively flattening bedrock for the chunk at " + cCoord.toString() + ".");
            regen = true;
        }
        if (ores) {
            CoFHWorld.log.log(Level.INFO, "Retroactively generating ores for the chunk at " + cCoord.toString() + ".");
            regen = true;
        }
        if (regen) {
            ArrayList chunks = (ArrayList)TickHandlerWorld.chunksToGen.get(dim);
            if (chunks == null) {
                TickHandlerWorld.chunksToGen.put(dim, new ArrayList());
                chunks = (ArrayList)TickHandlerWorld.chunksToGen.get(dim);
            }
            if (chunks != null) {
                chunks.add(cCoord);
                TickHandlerWorld.chunksToGen.put(dim, chunks);
            }
        }
    }

    @ForgeSubscribe
    public void handleOreGenEvent(OreGenEvent.GenerateMinable event) {
        if (!CoFHWorld.genReplaceVanilla) {
            return;
        }
        if (vanillaGenEvents.contains(event.type)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.generateWorld(random, chunkX, chunkZ, world, true);
    }

    @Override
    public boolean registerFeature(IFeatureGenerator feature) {
        if (featureNames.contains(feature.getFeatureName())) {
            return false;
        }
        featureNames.add(feature.getFeatureName());
        features.add(feature);
        return true;
    }

    public static boolean addFeature(IFeatureGenerator feature) {
        return instance.registerFeature(feature);
    }

    public void generateWorld(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        this.replaceBedrock(random, chunkX, chunkZ, world, newGen);
        if (!newGen && !CoFHWorld.retroOreGeneration) {
            return;
        }
        if (world.field_73011_w.field_76574_g == 1 || world.field_73011_w.field_76574_g == -1) {
            return;
        }
        for (IFeatureGenerator feature : features) {
            feature.generateFeature(random, chunkX, chunkZ, world, newGen);
        }
        if (!newGen) {
            world.func_72964_e(chunkX, chunkZ).func_76630_e();
        }
    }

    public void replaceBedrock(Random random, int chunkX, int chunkZ, World world, boolean newGen) {
        if (!CoFHWorld.genFlatBedrock || !newGen && !CoFHWorld.retroFlatBedrock) {
            return;
        }
        boolean isNether = world.func_72807_a((int)chunkX, (int)chunkZ).field_76791_y.toLowerCase().equals("hell");
        if (isNether) {
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    int blockY;
                    for (blockY = 126; blockY > 121; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_72012_bb.field_71990_ca, 0, 2);
                    }
                    for (blockY = 5; blockY > 0; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_72012_bb.field_71990_ca, 0, 2);
                    }
                }
            }
        } else {
            for (int blockX = 0; blockX < 16; ++blockX) {
                for (int blockZ = 0; blockZ < 16; ++blockZ) {
                    for (int blockY = 5; blockY > 0; --blockY) {
                        if (world.func_72798_a(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ) != Block.field_71986_z.field_71990_ca) continue;
                        world.func_72832_d(chunkX * 16 + blockX, blockY, chunkZ * 16 + blockZ, Block.field_71981_t.field_71990_ca, 0, 2);
                    }
                }
            }
        }
    }

    static {
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.COAL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIAMOND);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.DIRT);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GOLD);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.GRAVEL);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.IRON);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.LAPIS);
        vanillaGenEvents.add(OreGenEvent.GenerateMinable.EventType.REDSTONE);
        instance = new WorldHandler();
    }
}

