/*
 * Decompiled with CFR 0.152.
 */
package cofh.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import net.minecraft.util.StringTranslate;

public class Localization {
    private static String loadedLanguage = Localization.getCurrentLanguage();
    private static Properties defaultMappings = new Properties();
    private static Properties mappings = new Properties();
    private static LinkedList mods = new LinkedList();

    public static void addLocalization(String path, String defaultLanguage) {
        mods.add(new modInfo(path, defaultLanguage));
        Localization.load(path, defaultLanguage);
    }

    public static synchronized String get(String key) {
        if (Localization.getCurrentLanguage() != null && !Localization.getCurrentLanguage().equals(loadedLanguage)) {
            defaultMappings.clear();
            mappings.clear();
            for (modInfo mInfo : mods) {
                Localization.load(mInfo.modName, mInfo.defaultLanguage);
            }
            loadedLanguage = Localization.getCurrentLanguage();
        }
        return mappings.getProperty(key, defaultMappings.getProperty(key, key));
    }

    private static String getCurrentLanguage() {
        return StringTranslate.func_74808_a().func_74811_c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(String path, String default_language) {
        InputStream langStream = null;
        Properties modMappings = new Properties();
        try {
            langStream = Localization.class.getResourceAsStream(path + default_language + ".properties");
            modMappings.load(langStream);
            defaultMappings.putAll((Map<?, ?>)modMappings);
            langStream.close();
            langStream = Localization.class.getResourceAsStream(path + Localization.getCurrentLanguage() + ".properties");
            if (langStream != null) {
                modMappings.clear();
                modMappings.load(langStream);
            }
            mappings.putAll((Map<?, ?>)modMappings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (langStream != null) {
                    langStream.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class modInfo {
        final String modName;
        final String defaultLanguage;

        public modInfo(String modName, String defaultLanguage) {
            this.modName = modName;
            this.defaultLanguage = defaultLanguage;
        }
    }
}

