/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.element;

import cofh.gui.GuiRoot;
import cofh.gui.element.ElementRoot;
import cofh.render.RenderUtils;
import cofh.util.liquid.LiquidTankAdv;

public class ElementLiquidTank
extends ElementRoot {
    public static int SCALE = 60;
    public static final String TEXTURE = "/mods/cofh/textures/gui/elements/LiquidTank.png";
    protected LiquidTankAdv tank;
    protected int gaugeType;

    public ElementLiquidTank(GuiRoot gui, int posX, int posY, LiquidTankAdv tank) {
        super(gui, posX, posY);
        this.tank = tank;
        this.texture = TEXTURE;
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 16;
        this.sizeY = SCALE;
    }

    public ElementLiquidTank setGauge(int gaugeType) {
        this.gaugeType = gaugeType;
        return this;
    }

    @Override
    public void draw() {
        if (!this.visible) {
            return;
        }
        int qty = this.getScaled();
        this.gui.drawLiquid(this.posX, this.posY + this.sizeY - qty, this.tank.getLiquidNoCopy(), this.sizeX, qty);
        RenderUtils.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX, this.posY, 32 + this.gaugeType * 16, 1, this.sizeX, this.sizeY);
    }

    @Override
    public String getTooltip() {
        return "" + this.tank.getLiquidNoCopy().amount + " / " + this.tank.getCapacity() + " mB";
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        return false;
    }

    int getScaled() {
        return this.tank.getLiquidAmount() * this.sizeY / this.tank.getCapacity();
    }
}

