/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenAutumnTree
extends WorldGenerator {
    private static Block trunkBlock = Block.field_71951_J;
    private static int trunkMetadata = 1;
    private static ItemStack brownLeaves;
    private static ItemStack orangeLeaves;
    private static ItemStack purpleLeaves;
    private static ItemStack yellowLeaves;
    private static final int BASE_HEIGHT = 4;
    private static final int CANOPY_HEIGHT = 3;
    private static final int CANOPY_RADIUS_EXTRA_RADIUS = 0;
    private static final int MAX_VARIANCE_HEIGHT = 2;
    protected final AutumnTreeType type;

    private static boolean isBlockSuitableForGrowing(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        return TreeSoilRegistry.isValidSoil(id);
    }

    private static boolean isRoomToGrow(World world, int x, int y, int z, int height) {
        for (int i = y; i <= y + 1 + height; ++i) {
            if (i < 0 || i >= 256) {
                return false;
            }
            int radius = 1;
            if (i == y) {
                radius = 0;
            }
            if (i >= y + 1 + height - 2) {
                radius = 2;
            }
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    int id = world.func_72798_a(x1, i, z1);
                    if (Block.field_71973_m[id] == null || Block.field_71973_m[id].isLeaves(world, x1, i, z1) || id == Block.field_71980_u.field_71990_ca || Block.field_71973_m[id].isWood(world, x1, i, z1)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void setTrunkBlock(Block block, int metadata) {
        trunkBlock = block;
        trunkMetadata = metadata;
    }

    public WorldGenAutumnTree(boolean doBlockNotify, AutumnTreeType type) {
        super(doBlockNotify);
        this.type = type;
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int height = rand.nextInt(3) + 4;
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        if (!WorldGenAutumnTree.isBlockSuitableForGrowing(world, x, y - 1, z)) {
            return false;
        }
        if (!WorldGenAutumnTree.isRoomToGrow(world, x, y, z, height)) {
            return false;
        }
        world.func_94575_c(x, y - 1, z, Block.field_71979_v.field_71990_ca);
        this.growLeaves(world, rand, x, y, z, height, this.type.getID(), this.type.getMetadata());
        this.growTrunk(world, x, y, z, height, WorldGenAutumnTree.trunkBlock.field_71990_ca, trunkMetadata);
        return true;
    }

    private void growLeaves(World world, Random rand, int x, int y, int z, int height, int leafID, int leafMeta) {
        for (int y1 = y - 3 + height; y1 <= y + height; ++y1) {
            int canopyRow = y1 - (y + height);
            int radius = 1 - canopyRow / 2;
            for (int x1 = x - radius; x1 <= x + radius; ++x1) {
                int xDistanceFromTrunk = x1 - x;
                for (int z1 = z - radius; z1 <= z + radius; ++z1) {
                    int zDistanceFromTrunk = z1 - z;
                    Block block = Block.field_71973_m[world.func_72798_a(x1, y1, z1)];
                    if (Math.abs(xDistanceFromTrunk) == radius && Math.abs(zDistanceFromTrunk) == radius && (rand.nextInt(2) == 0 || canopyRow == 0) || block != null && !block.canBeReplacedByLeaves(world, x1, y1, z1)) continue;
                    this.func_76485_a(world, x1, y1, z1, leafID, leafMeta);
                }
            }
        }
    }

    private void growTrunk(World world, int x, int y, int z, int height, int woodID, int woodMeta) {
        for (int y1 = 0; y1 < height; ++y1) {
            int id = world.func_72798_a(x, y + y1, z);
            if (Block.field_71973_m[id] != null && !Block.field_71973_m[id].isLeaves(world, x, y + y1, z)) continue;
            this.func_76485_a(world, x, y + y1, z, woodID, woodMeta);
        }
    }

    static {
        orangeLeaves = brownLeaves = new ItemStack((Block)Block.field_71952_K);
        purpleLeaves = brownLeaves;
        yellowLeaves = brownLeaves;
    }

    public static enum AutumnTreeType {
        BROWN,
        ORANGE,
        PURPLE,
        YELLOW;

        private ItemStack leaves = new ItemStack((Block)Block.field_71952_K);
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_AUTUMN_BROWN.isPresent()) {
                AutumnTreeType.BROWN.leaves = Element.LEAVES_AUTUMN_BROWN.get();
            }
            if (Element.LEAVES_AUTUMN_ORANGE.isPresent()) {
                AutumnTreeType.ORANGE.leaves = Element.LEAVES_AUTUMN_ORANGE.get();
            }
            if (Element.LEAVES_AUTUMN_PURPLE.isPresent()) {
                AutumnTreeType.PURPLE.leaves = Element.LEAVES_AUTUMN_PURPLE.get();
            }
            if (Element.LEAVES_AUTUMN_YELLOW.isPresent()) {
                AutumnTreeType.YELLOW.leaves = Element.LEAVES_AUTUMN_YELLOW.get();
            }
            loadedCustomBlocks = true;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                AutumnTreeType.loadCustomBlocks();
            }
            return this.leaves.field_77993_c;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                AutumnTreeType.loadCustomBlocks();
            }
            return this.leaves.func_77960_j();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

