/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.thaumcraft;

import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.neiplugins.common.Utils;
import mods.neiplugins.thaumcraft.TCUtils;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneCraftingRecipes;
import thaumcraft.api.crafting.ShapelessArcaneCraftingRecipes;

public abstract class ArcaneRecipeHandler
extends LiquidTemplateRecipeHandler {
    static final int xoffset = 3;
    static final int yoffset = 7;
    static final int xgridoffset = 12;
    static final int ygridoffset = 13;
    static final int[][] stackorder = new int[][]{{0, 0}, {1, 0}, {0, 1}, {1, 1}, {0, 2}, {1, 2}, {2, 0}, {2, 1}, {2, 2}};

    public abstract String getRecipeNameSub();

    public abstract boolean isValidRecipe(IArcaneRecipe var1);

    public abstract boolean containIngredient(IArcaneRecipe var1, ItemStack var2);

    public abstract void setIngredient(CachedArcaneRecipe var1, IArcaneRecipe var2);

    public String getRecipeName() {
        return "Arcane Worktable";
    }

    @Override
    public String getRecipeId() {
        return "thaumcraft.arcane";
    }

    public String getGuiTexture() {
        return "/mods/thaumcraft/textures/gui/gui_researchbook_overlay.png";
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        gui.bindTexture(this.getGuiTexture());
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)3.0f, (float)7.0f, (float)0.0f);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        gui.drawTexturedModalRect(0, 0, 112, 15, 52, 52);
        gui.drawTexturedModalRect(58, 8, 20, 3, 16, 16);
        gui.drawTexturedModalRect(56, 28, 68, 76, 12, 12);
        GL11.glPopMatrix();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(115, 63, 24, 24), this.getRecipeId(), new Object[0]));
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        if (recipe % this.recipiesPerPage() == 0) {
            gui.drawTextCentered(this.getRecipeNameSub(), gui.window.field_74194_b / 2 - 5, -1, 0x404040, false);
        }
        IArcaneRecipe rc = ((CachedArcaneRecipe)((Object)this.arecipes.get((int)recipe))).recipe;
        gui.drawText(125, 78, rc.getCost() + " vis", -8355712, false);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public ArrayList getRecipeList() {
        ArrayList<IArcaneRecipe> result = new ArrayList<IArcaneRecipe>();
        for (Object recipe : ThaumcraftApi.getCraftingRecipes()) {
            if (!(recipe instanceof IArcaneRecipe) || !TCUtils.isResearchComplete(((IArcaneRecipe)recipe).getKey()) || !this.isValidRecipe((IArcaneRecipe)recipe)) continue;
            result.add((IArcaneRecipe)recipe);
        }
        return result;
    }

    @Override
    public void loadSameRecipeId() {
        for (IArcaneRecipe irecipe : this.getRecipeList()) {
            this.arecipes.add(new CachedArcaneRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (IArcaneRecipe irecipe : this.getRecipeList()) {
            if (!Utils.areStacksSameTypeCrafting(irecipe.getRecipeOutput(), result)) continue;
            this.arecipes.add(new CachedArcaneRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (IArcaneRecipe irecipe : this.getRecipeList()) {
            if (!this.containIngredient(irecipe, ingredient)) continue;
            this.arecipes.add(new CachedArcaneRecipe(irecipe));
        }
    }

    public static class ArcaneShapelessRecipeHandler
    extends ArcaneRecipeHandler {
        @Override
        public String getRecipeNameSub() {
            return "Shapeless";
        }

        @Override
        public boolean isValidRecipe(IArcaneRecipe irecipe) {
            return irecipe instanceof ShapelessArcaneCraftingRecipes;
        }

        @Override
        public boolean containIngredient(IArcaneRecipe recipe, ItemStack stack) {
            ShapelessArcaneCraftingRecipes irecipe = (ShapelessArcaneCraftingRecipes)recipe;
            for (Object recipeStack : irecipe.recipeItems) {
                if (!(recipeStack instanceof ItemStack) || !Utils.areStacksSameTypeCrafting((ItemStack)recipeStack, stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setIngredient(CachedArcaneRecipe cachedRecipe, IArcaneRecipe recipe) {
            ShapelessArcaneCraftingRecipes irecipe = (ShapelessArcaneCraftingRecipes)recipe;
            int counter = 0;
            for (Object recipeStack : irecipe.recipeItems) {
                if (!(recipeStack instanceof ItemStack)) continue;
                PositionedStack stack = new PositionedStack((Object)((ItemStack)recipeStack).func_77946_l(), 15 + stackorder[counter][0] * 32, 20 + stackorder[counter][1] * 32);
                stack.setMaxSize(1);
                cachedRecipe.ingredients.add(stack);
                ++counter;
            }
        }
    }

    public static class ArcaneShapedRecipeHandler
    extends ArcaneRecipeHandler {
        @Override
        public String getRecipeNameSub() {
            return "Shaped";
        }

        @Override
        public boolean isValidRecipe(IArcaneRecipe irecipe) {
            return irecipe instanceof ShapedArcaneCraftingRecipes;
        }

        @Override
        public boolean containIngredient(IArcaneRecipe recipe, ItemStack stack) {
            ShapedArcaneCraftingRecipes irecipe = (ShapedArcaneCraftingRecipes)recipe;
            for (int i = 0; i < irecipe.recipeWidth; ++i) {
                for (int j = 0; j < irecipe.recipeHeight; ++j) {
                    if (!Utils.areStacksSameTypeCrafting(irecipe.recipeItems[i + j * irecipe.recipeWidth], stack)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void setIngredient(CachedArcaneRecipe cachedRecipe, IArcaneRecipe recipe) {
            ShapedArcaneCraftingRecipes irecipe = (ShapedArcaneCraftingRecipes)recipe;
            for (int i = 0; i < irecipe.recipeWidth; ++i) {
                for (int j = 0; j < irecipe.recipeHeight; ++j) {
                    ItemStack ingredient = irecipe.recipeItems[i + j * irecipe.recipeWidth];
                    if (ingredient == null) continue;
                    PositionedStack stack = new PositionedStack((Object)ingredient.func_77946_l(), 15 + i * 32, 20 + j * 32);
                    stack.setMaxSize(1);
                    cachedRecipe.ingredients.add(stack);
                }
            }
        }
    }

    public class CachedArcaneRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack result;
        public ArrayList ingredients;
        public IArcaneRecipe recipe;

        public CachedArcaneRecipe(IArcaneRecipe irecipe) {
            super((TemplateRecipeHandler)ArcaneRecipeHandler.this);
            this.recipe = irecipe;
            this.result = new PositionedStack((Object)irecipe.getRecipeOutput(), 127, 31);
            this.ingredients = new ArrayList();
            ArcaneRecipeHandler.this.setIngredient(this, irecipe);
        }

        public ArrayList getIngredients() {
            return this.getCycledIngredients(ArcaneRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

