/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.tconstruct;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import mods.tinker.tconstruct.library.crafting.CastingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public abstract class CastRecipeHandler
extends LiquidTemplateRecipeHandler {
    public static final int xOffset = 30;
    static Rectangle metalTank = new Rectangle(60, 8, 6, 11);

    public String getRecipeName() {
        return "Coke Oven";
    }

    @Override
    public String getRecipeId() {
        return "Coke Oven";
    }

    public abstract ArrayList getCastingRecipes();

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 18, 22, 15), this.getRecipeId(), new Object[0]));
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (CastingRecipe recipe : this.getCastingRecipes()) {
                this.arecipes.add(new CachedCastingRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("liquid") && ingredients.length == 1 && ingredients[0] instanceof LiquidStack) {
            LiquidStack t = (LiquidStack)ingredients[0];
            for (CastingRecipe recipe : this.getCastingRecipes()) {
                if (!recipe.castingMetal.isLiquidEqual(t)) continue;
                this.arecipes.add(new CachedCastingRecipe(recipe));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingred) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingred);
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)recipe.cast, (ItemStack)ingred) && (t == null || !recipe.castingMetal.isLiquidEqual(t))) continue;
            this.arecipes.add(new CachedCastingRecipe(recipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CastingRecipe recipe : this.getCastingRecipes()) {
            if (!NEIClientUtils.areStacksSameType((ItemStack)result, (ItemStack)recipe.getResult())) continue;
            this.arecipes.add(new CachedCastingRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "/mods/neiplugins/gfx/tc_cast.png";
    }

    public class CachedCastingRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        PositionedStack cast;
        LiquidTank metal;
        PositionedStack output;

        public CachedCastingRecipe(CastingRecipe irecipe) {
            super((TemplateRecipeHandler)CastRecipeHandler.this);
            this.cast = null;
            this.output = null;
            this.metal = new LiquidTank(irecipe.castingMetal, irecipe.castingMetal.amount, metalTank);
            this.metal.showMillBuckets = true;
            this.metal.showCapacity = false;
            this.metal.showAmount = true;
            if (irecipe.cast != null) {
                this.cast = new PositionedStack((Object)irecipe.cast, 55, 19);
            }
            this.output = new PositionedStack((Object)irecipe.output, 110, 18);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getIngredient() {
            return this.cast;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.metal);
            return res;
        }
    }
}

