/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.railcraft;

import java.util.HashMap;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import mods.neiplugins.common.Utils;
import mods.neiplugins.railcraft.BoilerFuelContextHelper;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class RailcraftFuelHelper {
    public static Class guiCartBore;
    public static Class guiEngineSteamHobby;
    public static Class GuiLocomotiveSteam;

    public static int getFuelValue(ItemStack stack) {
        int fuelValue = 0;
        try {
            fuelValue = FuelPlugin.getBurnTime((ItemStack)stack);
        }
        catch (Exception ex) {
            return 0;
        }
        return fuelValue;
    }

    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.enginesteamhobby", "Hobbyist's Steam Engine", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                int fuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.convertMJtF(1.6f) + " MJ/t up to " + fuelValue / 8 * 20 + " ticks (Hobbyist's Steam Engine)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.locomotivesteam", "Steam Locomotive", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                int fuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a7780 Steam/t up to " + Math.round((double)fuelValue / 6.4) * 2L + " ticks (Steam Locomotive)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.tunnelbore", "Tunnel Bore", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                int fuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (fuelValue > 0) {
                    currenttip.add("\u00a77Heat to work for " + fuelValue / 12 + " ticks (Tunnel Bore)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(true, new SimpleFuelHelper("railcraft.solidfirebox", "Solid Fueled Firebox", null){

            @Override
            public List getItemStackFuelTooltip(ItemStack stack, List currenttip) {
                int boilerFuelValue = RailcraftFuelHelper.getFuelValue(stack);
                if (boilerFuelValue > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.convertHeatValue(boilerFuelValue, 1) + " (Solid Fueled Firebox)");
                }
                return currenttip;
            }
        });
        FuelTooltip.addFuelHelper(new SimpleFuelHelper("railcraft.liquidfirebox", "Liquid Fueled Firebox", null){

            @Override
            public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
                LiquidStack tempLiquid = liquid.copy();
                tempLiquid.amount = 1000;
                int boilerFuelValue = FuelManager.getBoilerFuelValue((LiquidStack)tempLiquid);
                if (boilerFuelValue > 0) {
                    currenttip.add("\u00a77" + FuelTooltip.convertHeatValue(boilerFuelValue * liquid.amount / 1000, 1) + " (Liquid Fueled Firebox)");
                }
                return currenttip;
            }
        });
        Class liquidGui = Utils.findClass("mods.railcraft.client.gui.GuiBoilerLiquid");
        Class solidGui = Utils.findClass("mods.railcraft.client.gui.GuiBoilerSolid");
        if (liquidGui != null && solidGui != null) {
            FuelTooltip.addContextFuelHelper(new BoilerFuelContextHelper(solidGui, liquidGui));
        }
        HashMap<Class, String> map = new HashMap<Class, String>();
        if (guiEngineSteamHobby != null) {
            map.put(guiEngineSteamHobby, "railcraft.enginesteamhobby");
        }
        if (GuiLocomotiveSteam != null) {
            map.put(GuiLocomotiveSteam, "railcraft.locomotivesteam");
        }
        if (guiCartBore != null) {
            map.put(guiCartBore, "railcraft.tunnelbore");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("railcraft.all", "Railcraft", null, map));
        }
    }
}

