/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineFermenter;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class FermenterRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(30, 8, 16, 58);
    static Rectangle outputTank = new Rectangle(120, 8, 16, 58);
    static Point overlayTank = new Point(176, 0);
    public static ArrayList fuels;

    @Override
    public String getRecipeId() {
        return "forestry.fermenter";
    }

    public String getRecipeName() {
        return "Fermenter";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 31, 14, 12), this.getRecipeId(), new Object[0]));
    }

    public ArrayList getRecipes() {
        MachineFermenter.RecipeManager cfr_ignored_0 = (MachineFermenter.RecipeManager)RecipeManagers.fermenterManager;
        return MachineFermenter.RecipeManager.recipes;
    }

    @Override
    public void loadCraftingRecipes(LiquidStack result) {
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.output, result)) continue;
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    @Override
    public void loadUsageRecipes(LiquidStack ingredient) {
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.liquid, ingredient)) continue;
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedFermenterRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        LiquidStack t = LiquidHelper.getLiquidStack(result);
        if (t != null) {
            for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
                if (!LiquidHelper.areSameLiquid(irecipe.output, t)) continue;
                this.arecipes.add(new CachedFermenterRecipe(irecipe).replaceMetaOnBottlerSlots(result));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        LiquidStack t = LiquidHelper.getLiquidStack(ingredient);
        for (MachineFermenter.Recipe irecipe : this.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.resource, (ItemStack)ingredient) && !LiquidHelper.areSameLiquid(irecipe.liquid, t)) continue;
            CachedFermenterRecipe recipe = new CachedFermenterRecipe(irecipe);
            recipe.setStacksPermutation(ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/fermenter.png";
    }

    public static void loadFuels() {
        fuels = new ArrayList(FuelManager.fermenterFuel.keySet());
    }

    public class CachedFermenterRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        PositionedStack slot_resource;
        PositionedStack slot_can_output;
        PositionedStack slot_can_input;
        PositionedStack slot_input;
        LiquidTank input;
        LiquidTank output;

        public CachedFermenterRecipe(MachineFermenter.Recipe recipe) {
            super((TemplateRecipeHandler)FermenterRecipeHandler.this);
            this.input = new LiquidTank(recipe.liquid, 10000, inputTank, overlayTank);
            this.output = new LiquidTank(recipe.output, 10000, outputTank, overlayTank);
            this.input.liquid.amount = recipe.fermentationValue;
            this.output.liquid.amount = Math.round((float)recipe.fermentationValue * recipe.modifier);
            this.slot_resource = new PositionedStack((Object)recipe.resource, 80, 12);
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.input.liquid, 25, 29, 5, 29);
            PositionedStack[] output_cont = LiquidHelper.generateStacksForLiquid(this.output.liquid, 145, 11, 145, 47);
            this.slot_input = input_cont[1];
            this.slot_can_input = output_cont[0];
            this.slot_can_output = output_cont[1];
        }

        public ArrayList getIngredients() {
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            if (this.slot_resource != null) {
                cycledstacks.add(this.slot_resource);
            }
            if (this.slot_input != null) {
                cycledstacks.add(this.slot_input);
            }
            return this.getCycledIngredients(FermenterRecipeHandler.this.cycleticks / 20, cycledstacks);
        }

        public void setStacksPermutation(ItemStack ingredient) {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_resource != null) {
                stacks.add(this.slot_resource);
            }
            if (this.slot_input != null) {
                stacks.add(this.slot_input);
            }
            this.setIngredientPermutation(stacks, ingredient);
        }

        public PositionedStack getResult() {
            return LiquidHelper.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_output);
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.slot_can_input != null) {
                stacks.add(LiquidHelper.getSeqCycledStack(FermenterRecipeHandler.this.cycleticks / 20, this.slot_can_input));
            }
            if (fuels != null && fuels.size() > 0) {
                stacks.add(new PositionedStack(fuels.get(FermenterRecipeHandler.this.cycleticks / 40 % fuels.size()), 70, 46));
            }
            return stacks;
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            res.add(this.output);
            return res;
        }

        public CachedFermenterRecipe replaceMetaOnBottlerSlots(ItemStack ingredient) {
            if (this.slot_can_output.items.length == 1 && this.slot_can_input == null) {
                return this;
            }
            for (int i = 0; i < this.slot_can_output.items.length; ++i) {
                if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)this.slot_can_output.items[i])) continue;
                this.slot_can_output.item = this.slot_can_output.items[i];
                this.slot_can_output.item.func_77964_b(ingredient.func_77960_j());
                this.slot_can_output.items = new ItemStack[]{this.slot_can_output.item};
                this.slot_can_output.setPermutationToRender(0);
                this.slot_can_input.item = this.slot_can_input.items[i];
                this.slot_can_input.items = new ItemStack[]{this.slot_can_input.item};
                this.slot_can_input.setPermutationToRender(0);
                break;
            }
            return this;
        }
    }
}

