/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import forestry.api.recipes.RecipeManagers;
import forestry.core.interfaces.IDescriptiveRecipe;
import forestry.factory.gadgets.MachineFabricator;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.Utils;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;

public class FabricatorRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(21, 37, 16, 16);
    public static HashMap moltensCacheLiquid = new HashMap();
    public static HashMap moltensCacheItemStack = new HashMap();

    @Override
    public String getRecipeId() {
        return "forestry.fabricator";
    }

    public String getRecipeName() {
        return "Thermionic Fabricator";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(117, 44, 14, 13), this.getRecipeId(), new Object[0]));
    }

    public ArrayList getRecipes() {
        MachineFabricator.RecipeManager cfr_ignored_0 = (MachineFabricator.RecipeManager)RecipeManagers.fabricatorManager;
        return MachineFabricator.RecipeManager.recipes;
    }

    @Override
    public void loadUsageRecipes(LiquidStack ingredient) {
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(irecipe.getLiquid(), ingredient)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedFabricatorRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            if (!Utils.areStacksSameTypeCrafting(irecipe.asIRecipe().func_77571_b(), result)) continue;
            this.arecipes.add(new CachedFabricatorRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        LiquidStack t = this.getMoltenLiquidFromItemStack(ingredient);
        for (MachineFabricator.Recipe irecipe : this.getRecipes()) {
            CachedFabricatorRecipe recipe;
            if (this.containsIngredient(irecipe.asIRecipe(), ingredient) || Utils.areStacksSameTypeCrafting(FabricatorRecipeHandler.getPlan(irecipe), ingredient)) {
                recipe = new CachedFabricatorRecipe(irecipe);
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
                continue;
            }
            if (t == null || !LiquidHelper.areSameLiquid(irecipe.getLiquid(), t)) continue;
            recipe = new CachedFabricatorRecipe(irecipe);
            recipe.setIngredientPermutation(recipe.moltens, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return "/gfx/forestry/gui/fabricator.png";
    }

    protected static int liquidToInt(LiquidStack liquid) {
        if (liquid == null) {
            return 0;
        }
        return liquid.itemID | liquid.itemMeta << 16;
    }

    protected static ItemStack getPlan(MachineFabricator.Recipe recipe) {
        return (ItemStack)ObfuscationReflectionHelper.getPrivateValue(MachineFabricator.Recipe.class, (Object)recipe, (int)0);
    }

    public static void buildMoltensCache() {
        ArrayList smeltings = (ArrayList)ObfuscationReflectionHelper.getPrivateValue(MachineFabricator.RecipeManager.class, (Object)((MachineFabricator.RecipeManager)RecipeManagers.fabricatorManager), (int)1);
        for (MachineFabricator.Smelting smelting : smeltings) {
            ItemStack resource = (ItemStack)ObfuscationReflectionHelper.getPrivateValue(MachineFabricator.Smelting.class, (Object)smelting, (int)0);
            LiquidStack liquid = (LiquidStack)ObfuscationReflectionHelper.getPrivateValue(MachineFabricator.Smelting.class, (Object)smelting, (int)1);
            int key = Utils.itemStackToInt(resource);
            if (moltensCacheItemStack.containsKey(key)) continue;
            moltensCacheItemStack.put(key, liquid);
            key = FabricatorRecipeHandler.liquidToInt(liquid);
            if (!moltensCacheLiquid.containsKey(key)) {
                moltensCacheLiquid.put(key, new ArrayList());
            }
            ArrayList t = (ArrayList)moltensCacheLiquid.get(key);
            t.add(resource);
        }
    }

    public ArrayList getMoltensFromLiquid(LiquidStack liquid) {
        if (liquid == null || liquid.itemID == 0 || liquid.amount == 0) {
            return null;
        }
        if (moltensCacheLiquid.containsKey(FabricatorRecipeHandler.liquidToInt(liquid))) {
            return (ArrayList)moltensCacheLiquid.get(FabricatorRecipeHandler.liquidToInt(liquid));
        }
        return null;
    }

    public LiquidStack getMoltenLiquidFromItemStack(ItemStack stack) {
        int key = Utils.itemStackToInt(stack);
        if (key != 0) {
            return (LiquidStack)moltensCacheItemStack.get(key);
        }
        return null;
    }

    public class CachedFabricatorRecipe
    extends ForestryRecipeHandler.CachedShapedRecipeCustom
    implements ICachedRecipeWithLiquidTank {
        public ArrayList moltens;
        public LiquidTank input;

        public CachedFabricatorRecipe(MachineFabricator.Recipe recipe) {
            ItemStack plan;
            super(FabricatorRecipeHandler.this);
            this.xoffset = 62;
            this.yoffset = 6;
            this.xproduct = 134;
            this.yproduct = 42;
            this.ingredients = new ArrayList();
            this.setIngredients((IDescriptiveRecipe)recipe.asIRecipe());
            this.input = new LiquidTank(recipe.getLiquid(), 2000, inputTank);
            this.moltens = new ArrayList();
            ArrayList moltenItems = FabricatorRecipeHandler.this.getMoltensFromLiquid(this.input.liquid);
            if (moltenItems.size() > 0) {
                this.moltens.add(new PositionedStack((Object)moltenItems, 21, 10));
            }
            if ((plan = FabricatorRecipeHandler.getPlan(recipe)) != null) {
                this.ingredients.add(new PositionedStack((Object)plan, 134, 6));
            }
        }

        @Override
        public ArrayList getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            return res;
        }

        public ArrayList getOtherStacks() {
            return this.getCycledIngredients(FabricatorRecipeHandler.this.cycleticks / 20, this.moltens);
        }
    }
}

