/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class SinkBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider {
    private static final int SYNC_INTERVAL = 10;
    private final FluidTank sinkTank = new FluidTank(16000){

        public class_3611 getFluid() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return class_3612.field_15910;
            }
            return super.getFluid();
        }

        public int getAmount() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getAmount();
        }

        public int getCapacity() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public int drain(class_3611 fluid, int maxDrain, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater && fluid == class_3612.field_15910) {
                return maxDrain;
            }
            if (fluid.method_15780(class_3612.field_15906) || !fluid.method_15780(fluid)) {
                return 0;
            }
            SinkBlockEntity.this.method_5431();
            return super.drain(fluid, maxDrain, simulate);
        }

        public int fill(class_3611 fluid, int maxFill, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return maxFill;
            }
            SinkBlockEntity.this.method_5431();
            return super.fill(fluid, maxFill, simulate);
        }
    };
    private final SinkItemProvider itemProvider = new SinkItemProvider(this.sinkTank);
    private int ticksSinceSync;
    private boolean isDirty;
    private class_1767 color = class_1767.field_7952;

    public SinkBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.sink.get(), pos, state);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("FluidTank", (class_2520)this.sinkTank.serialize());
        tag.method_10567("Color", (byte)this.color.method_7789());
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.sinkTank.deserialize(tag.method_10562("FluidTank"));
        this.color = class_1767.method_7791((int)tag.method_10571("Color"));
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, SinkBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void method_5431() {
        super.method_5431();
        this.isDirty = true;
    }

    public FluidTank getFluidTank() {
        return this.sinkTank;
    }

    private class SinkItemProvider
    extends AbstractKitchenItemProvider {
        private final class_2371<class_1799> itemStacks = class_2371.method_10211();
        private final FluidTank fluidTank;
        private int waterUsed;

        public SinkItemProvider(FluidTank fluidTank) {
            this.fluidTank = fluidTank;
            this.itemStacks.addAll(CookingRegistry.getWaterItems());
        }

        @Override
        public void resetSimulation() {
            this.waterUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.waterUsed / 1000;
        }

        @Override
        public class_1799 useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            int availableAmount = this.fluidTank.getAmount();
            if (simulate) {
                availableAmount -= this.waterUsed;
            }
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater || availableAmount >= amount * 1000) {
                if (requireBucket && ((class_1799)this.itemStacks.get(slot)).method_7909() == class_1802.field_8103 && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return class_1799.field_8037;
                }
                if (simulate) {
                    this.waterUsed += amount * 1000;
                } else {
                    this.fluidTank.drain((class_3611)class_3612.field_15910, amount * 1000, false);
                    SinkBlockEntity.this.method_5431();
                }
                return ContainerUtils.copyStackWithSize((class_1799)((class_1799)this.itemStacks.get(slot)), (int)amount);
            }
            return class_1799.field_8037;
        }

        @Override
        public class_1799 returnItemStack(class_1799 itemStack, SourceItem sourceItem) {
            for (class_1799 providedStack : this.itemStacks) {
                if (!Balm.getHooks().canItemsStack(itemStack, providedStack)) continue;
                this.fluidTank.fill((class_3611)class_3612.field_15910, 1000, false);
                break;
            }
            return class_1799.field_8037;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        public class_1799 getStackInSlot(int slot) {
            if (CookingForBlockheadsConfig.getActive().sinkRequiresWater && this.fluidTank.getAmount() - this.waterUsed < 1000) {
                return class_1799.field_8037;
            }
            return (class_1799)this.itemStacks.get(slot);
        }
    }
}

