/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.AbstractKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3611;

public class MilkJarBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider {
    protected static final int MILK_CAPACITY = 32000;
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);
    protected final FluidTank milkTank = new FluidTank(32000){

        public boolean canFill(class_3611 fluid) {
            return fluid.method_15780(Compat.getMilkFluid()) && super.canFill(fluid);
        }

        public void setChanged() {
            MilkJarBlockEntity.this.method_5431();
        }
    };

    public MilkJarBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591<? extends MilkJarBlockEntity>)((class_2591)ModBlockEntities.milkJar.get()), pos, state);
    }

    protected MilkJarBlockEntity(class_2591<? extends MilkJarBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("FluidTank", (class_2520)this.milkTank.serialize());
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.milkTank.deserialize(tag.method_10562("FluidTank"));
    }

    public void writeUpdateTag(class_2487 tag) {
        this.method_11007(tag);
    }

    public FluidTank getFluidTank() {
        return this.milkTank;
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    private static class MilkJarItemProvider
    extends AbstractKitchenItemProvider {
        private final class_2371<class_1799> itemStacks = class_2371.method_10211();
        private final MilkJarBlockEntity milkJar;
        private int milkUsed;

        public MilkJarItemProvider(MilkJarBlockEntity milkJar) {
            this.milkJar = milkJar;
            this.itemStacks.addAll(CookingRegistry.getMilkItems());
        }

        @Override
        public void resetSimulation() {
            this.milkUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.milkUsed / 1000;
        }

        @Override
        public class_1799 useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (this.milkJar.getFluidTank().getAmount() - this.milkUsed >= amount * 1000) {
                if (requireBucket && ((class_1799)this.itemStacks.get(slot)).method_7909() == class_1802.field_8103 && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return class_1799.field_8037;
                }
                if (simulate) {
                    this.milkUsed += amount * 1000;
                } else {
                    this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), amount * 1000, false);
                }
                return ContainerUtils.copyStackWithSize((class_1799)((class_1799)this.itemStacks.get(slot)), (int)amount);
            }
            return class_1799.field_8037;
        }

        @Override
        public class_1799 returnItemStack(class_1799 itemStack, SourceItem sourceItem) {
            for (class_1799 providedStack : this.itemStacks) {
                if (!Balm.getHooks().canItemsStack(itemStack, providedStack)) continue;
                this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
                break;
            }
            return class_1799.field_8037;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        public class_1799 getStackInSlot(int slot) {
            if (this.milkJar.getFluidTank().getAmount() - this.milkUsed < 1000) {
                return class_1799.field_8037;
            }
            return (class_1799)this.itemStacks.get(slot);
        }

        @Override
        public int getCountInSlot(int slot) {
            return this.milkJar.getFluidTank().getAmount() / 1000;
        }
    }
}

