/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.impl;

import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl.api.Binding;
import dev.isxander.yacl.api.Controller;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionFlag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionImpl<T>
implements Option<T> {
    private final class_2561 name;
    private class_2561 tooltip;
    private final Controller<T> controller;
    private final Binding<T> binding;
    private boolean available;
    private final ImmutableSet<OptionFlag> flags;
    private final Class<T> typeClass;
    private T pendingValue;
    private final List<BiConsumer<Option<T>, T>> listeners;

    public OptionImpl(@NotNull class_2561 name, @Nullable Function<T, class_2561> tooltipGetter, @NotNull Function<Option<T>, Controller<T>> controlGetter, @NotNull Binding<T> binding, boolean available, ImmutableSet<OptionFlag> flags, @NotNull Class<T> typeClass, @NotNull Collection<BiConsumer<Option<T>, T>> listeners) {
        this.name = name;
        this.binding = binding;
        this.available = available;
        this.flags = flags;
        this.typeClass = typeClass;
        this.listeners = new ArrayList<BiConsumer<Option<T>, T>>(listeners);
        this.controller = controlGetter.apply(this);
        this.addListener((opt, pending) -> {
            this.tooltip = (class_2561)tooltipGetter.apply(pending);
        });
        this.requestSet(this.binding().getValue());
    }

    @Override
    @NotNull
    public class_2561 name() {
        return this.name;
    }

    @Override
    @NotNull
    public class_2561 tooltip() {
        return this.tooltip;
    }

    @Override
    @NotNull
    public Controller<T> controller() {
        return this.controller;
    }

    @Override
    @NotNull
    public Binding<T> binding() {
        return this.binding;
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    @NotNull
    public Class<T> typeClass() {
        return this.typeClass;
    }

    @Override
    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return this.flags;
    }

    @Override
    public boolean requiresRestart() {
        return this.flags.contains((Object)OptionFlag.GAME_RESTART);
    }

    @Override
    public boolean changed() {
        return !this.binding().getValue().equals(this.pendingValue);
    }

    @Override
    @NotNull
    public T pendingValue() {
        return this.pendingValue;
    }

    @Override
    public void requestSet(T value) {
        this.pendingValue = value;
        this.listeners.forEach(listener -> listener.accept(this, this.pendingValue));
    }

    @Override
    public boolean applyValue() {
        if (this.changed()) {
            this.binding().setValue(this.pendingValue);
            return true;
        }
        return false;
    }

    @Override
    public void forgetPendingValue() {
        this.requestSet(this.binding().getValue());
    }

    @Override
    public void requestSetDefault() {
        this.requestSet(this.binding().defaultValue());
    }

    @Override
    public boolean isPendingValueDefault() {
        return this.binding().defaultValue().equals(this.pendingValue());
    }

    @Override
    public void addListener(BiConsumer<Option<T>, T> changedListener) {
        this.listeners.add(changedListener);
    }
}

