/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl.api;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl.api.ConfigCategory;
import dev.isxander.yacl.api.PlaceholderCategory;
import dev.isxander.yacl.gui.YACLScreen;
import dev.isxander.yacl.impl.YetAnotherConfigLibImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface YetAnotherConfigLib {
    public class_2561 title();

    public ImmutableList<ConfigCategory> categories();

    public Runnable saveFunction();

    public Consumer<YACLScreen> initConsumer();

    public class_437 generateScreen(@Nullable class_437 var1);

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private class_2561 title;
        private final List<ConfigCategory> categories = new ArrayList<ConfigCategory>();
        private Runnable saveFunction = () -> {};
        private Consumer<YACLScreen> initConsumer = screen -> {};

        private Builder() {
        }

        public Builder title(@NotNull class_2561 title) {
            Validate.notNull((Object)title, (String)"`title` cannot be null", (Object[])new Object[0]);
            this.title = title;
            return this;
        }

        public Builder category(@NotNull ConfigCategory category) {
            Validate.notNull((Object)category, (String)"`category` cannot be null", (Object[])new Object[0]);
            this.categories.add(category);
            return this;
        }

        public Builder categories(@NotNull Collection<? extends ConfigCategory> categories) {
            Validate.notNull(categories, (String)"`categories` cannot be null", (Object[])new Object[0]);
            this.categories.addAll(categories);
            return this;
        }

        public Builder save(@NotNull Runnable saveFunction) {
            Validate.notNull((Object)saveFunction, (String)"`saveFunction` cannot be null", (Object[])new Object[0]);
            this.saveFunction = saveFunction;
            return this;
        }

        public Builder screenInit(@NotNull Consumer<YACLScreen> initConsumer) {
            Validate.notNull(initConsumer, (String)"`initConsumer` cannot be null", (Object[])new Object[0]);
            this.initConsumer = initConsumer;
            return this;
        }

        public YetAnotherConfigLib build() {
            Validate.notNull((Object)this.title, (String)"`title must not be null to build `YetAnotherConfigLib`", (Object[])new Object[0]);
            Validate.notEmpty(this.categories, (String)"`categories` must not be empty to build `YetAnotherConfigLib`", (Object[])new Object[0]);
            Validate.isTrue((!this.categories.stream().allMatch(category -> category instanceof PlaceholderCategory) ? 1 : 0) != 0, (String)"At least one regular category is required to build `YetAnotherConfigLib`", (Object[])new Object[0]);
            return new YetAnotherConfigLibImpl(this.title, (ImmutableList<ConfigCategory>)ImmutableList.copyOf(this.categories), this.saveFunction, this.initConsumer);
        }
    }
}

