/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2346;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3614;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.api.FENApiModule;
import wraith.fabricaeexnihilo.api.FENRegistries;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.ModItems;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlock;
import wraith.fabricaeexnihilo.modules.crucibles.CrucibleBlock;
import wraith.fabricaeexnihilo.modules.farming.PlantableItem;
import wraith.fabricaeexnihilo.modules.farming.TallPlantableItem;
import wraith.fabricaeexnihilo.modules.farming.TransformingItem;
import wraith.fabricaeexnihilo.modules.infested.InfestedLeavesBlock;
import wraith.fabricaeexnihilo.modules.sieves.MeshItem;
import wraith.fabricaeexnihilo.modules.sieves.SieveBlock;
import wraith.fabricaeexnihilo.modules.strainer.StrainerBlock;
import wraith.fabricaeexnihilo.util.Color;
import wraith.fabricaeexnihilo.util.Lazy;

public class EntrypointHelper {
    public static final Map<class_1935, List<ConditionJsonProvider>> CONDITIONS = Maps.newIdentityHashMap();

    public static void callEntrypoints() {
        Stream<Object> entrypoints = FabricLoader.getInstance().getEntrypoints("fabricaeexnihilo:api", FENApiModule.class).stream();
        if (System.getProperty("fabric-api.datagen") == null) {
            entrypoints = entrypoints.filter(FENApiModule::shouldLoad);
        }
        entrypoints.forEach(entrypoint -> entrypoint.onInit(new FENRegistriesImpl(entrypoint.getResourceCondition())));
    }

    private static class_2960 id(String ore, @Nullable String prefix, @Nullable String suffix) {
        return FabricaeExNihilo.id((prefix == null ? "" : prefix) + ore + (suffix == null ? "" : suffix));
    }

    private static final class FENRegistriesImpl
    implements FENRegistries {
        @Nullable
        private final ConditionJsonProvider condition;

        private FENRegistriesImpl(@Nullable ConditionJsonProvider condition) {
            this.condition = condition;
        }

        @Override
        public FabricItemSettings defaultItemSettings() {
            return new FabricItemSettings().group(FabricaeExNihilo.ITEM_GROUP);
        }

        @Override
        public FabricBlockSettings gravelyBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15916).strength(0.6f).sounds(class_2498.field_11529));
        }

        @Override
        public FabricBlockSettings infestedLeavesBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970.class_2251)ModBlocks.INFESTED_LEAVES_SETTINGS);
        }

        @Override
        public FabricBlockSettings sandyBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15916).strength(0.4f).sounds(class_2498.field_11526));
        }

        @Override
        public FabricBlockSettings stoneBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15914).strength(2.0f, 6.0f).sounds(class_2498.field_11544).requiresTool());
        }

        @Override
        public FabricBlockSettings woodenBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970.class_2251)FabricBlockSettings.of((class_3614)class_3614.field_15932).strength(2.0f).sounds(class_2498.field_11547));
        }

        @Override
        public void registerBarrel(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_barrel");
            BarrelBlock block = ModBlocks.BARRELS.computeIfAbsent(id, __ -> {
                BarrelBlock block1 = new BarrelBlock(settings, isFireproof);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerCrucible(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_crucible");
            CrucibleBlock block = ModBlocks.CRUCIBLES.computeIfAbsent(id, __ -> {
                CrucibleBlock block1 = new CrucibleBlock(settings, isFireproof);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerCrushedBlock(String name, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, null);
            class_2248 block = ModBlocks.CRUSHED.computeIfAbsent(id, __ -> new class_2346(settings));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerInfestedLeaves(String name, class_2960 source, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, "infested_", "_leaves");
            InfestedLeavesBlock block = ModBlocks.INFESTED_LEAVES.computeIfAbsent(id, __ -> {
                InfestedLeavesBlock block1 = new InfestedLeavesBlock(source, settings);
                FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 30, 60);
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerMesh(String name, Color color, int enchantability, class_1792.class_1793 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_mesh");
            MeshItem item = ModItems.MESHES.computeIfAbsent(id, __ -> new MeshItem(color, enchantability, settings));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerOrePiece(String name, class_1792.class_1793 settings) {
            class_2960 id = EntrypointHelper.id(name, "raw_", "_piece");
            class_1792 item = ModItems.ORE_PIECES.computeIfAbsent(id, __ -> new class_1792((class_1792.class_1793)ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerSeed(String name, Lazy<class_2248[]> plants) {
            class_2960 id = EntrypointHelper.id(name, null, "_seeds");
            class_1792 item = ModItems.SEEDS.computeIfAbsent(id, __ -> new PlantableItem(plants, ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerSieve(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_sieve");
            SieveBlock block = ModBlocks.SIEVES.computeIfAbsent(id, __ -> {
                SieveBlock block1 = new SieveBlock(settings);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerStrainer(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_strainer");
            StrainerBlock block = ModBlocks.STRAINERS.computeIfAbsent(id, __ -> {
                StrainerBlock block1 = new StrainerBlock(settings);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerTallPlantSeed(String name, Lazy<class_2320[]> plants) {
            class_2960 id = EntrypointHelper.id(name, null, "_seeds");
            class_1792 item = ModItems.SEEDS.computeIfAbsent(id, __ -> new TallPlantableItem(plants, ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
        }

        @Override
        public void registerTransformingSeed(String name, Lazy<class_2248> from, Lazy<class_2248> to) {
            class_2960 id = EntrypointHelper.id(name, null, "_seeds");
            class_1792 item = ModItems.SEEDS.computeIfAbsent(id, __ -> new TransformingItem(from, to, ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
        }
    }
}

