/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3611;
import org.apache.logging.log4j.Logger;
import wraith.fabricaeexnihilo.FabricaeExNihilo;

public class CodecUtils {
    public static final Codec<FluidVariant> FLUID_VARIANT = CodecUtils.magicCodec(class_2378.field_11154.method_39673().xmap(FluidVariant::of, FluidVariant::getFluid), RecordCodecBuilder.create(instance1 -> instance1.group((App)class_2378.field_11154.method_39673().fieldOf("type").forGetter(FluidVariant::getFluid), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(variant -> Optional.ofNullable(variant.getNbt()))).apply((Applicative)instance1, (fluid, nbt) -> FluidVariant.of((class_3611)fluid, (class_2487)nbt.orElse(null)))));
    public static final Codec<class_1799> ITEM_STACK = CodecUtils.magicCodec(class_2378.field_11142.method_39673().xmap(class_1792::method_7854, class_1799::method_7909), RecordCodecBuilder.create(instance1 -> instance1.group((App)class_2378.field_11142.method_39673().fieldOf("item").forGetter(class_1799::method_7909), (App)Codec.INT.optionalFieldOf("count").forGetter(stack -> Optional.of(stack.method_7947())), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(itemStack -> Optional.ofNullable(itemStack.method_7969()))).apply((Applicative)instance1, (item, count, nbt) -> {
        class_1799 stack = new class_1799((class_1935)item);
        count.ifPresent(arg_0 -> ((class_1799)stack).method_7939(arg_0));
        nbt.ifPresent(arg_0 -> ((class_1799)stack).method_7980(arg_0));
        return stack;
    })));

    private static <T> Codec<T> magicCodec(Codec<T> simple, Codec<T> expanded) {
        return Codec.either(simple, expanded).xmap(either -> either.map(Function.identity(), Function.identity()), Either::right);
    }

    public static <T> T fromPacket(Codec<T> codec, class_2540 buf) {
        boolean packed = buf.readBoolean();
        class_2487 nbt = buf.method_10798();
        return CodecUtils.fromNbt(codec, (class_2520)(packed && nbt != null ? nbt.method_10580("value") : nbt));
    }

    public static <T> void toPacket(Codec<T> codec, T data, class_2540 buf) {
        class_2520 nbtData = CodecUtils.toNbt(codec, data);
        if (!(nbtData instanceof class_2487)) {
            buf.writeBoolean(true);
            class_2487 compound = new class_2487();
            compound.method_10566("value", nbtData);
            buf.method_10794(compound);
            return;
        }
        class_2487 compound = (class_2487)nbtData;
        buf.writeBoolean(false);
        buf.method_10794(compound);
    }

    public static <T> T fromNbt(Codec<T> codec, class_2520 data) {
        return CodecUtils.deserialize(codec, class_2509.field_11560, data);
    }

    public static <T> class_2520 toNbt(Codec<T> codec, T data) {
        return (class_2520)CodecUtils.serialize(codec, class_2509.field_11560, data);
    }

    public static <T> T fromJson(Codec<T> codec, JsonElement data) {
        return CodecUtils.deserialize(codec, JsonOps.INSTANCE, data);
    }

    public static <T> JsonElement toJson(Codec<T> codec, T data) {
        return (JsonElement)CodecUtils.serialize(codec, JsonOps.INSTANCE, data);
    }

    public static <T, O> T deserialize(Codec<T> codec, DynamicOps<O> ops, O data) {
        return (T)((Pair)codec.decode(ops, data).getOrThrow(false, arg_0 -> ((Logger)FabricaeExNihilo.LOGGER).warn(arg_0))).getFirst();
    }

    public static <T, O> O serialize(Codec<T> codec, DynamicOps<O> ops, T data) {
        return (O)codec.encodeStart(ops, data).getOrThrow(false, arg_0 -> ((Logger)FabricaeExNihilo.LOGGER).warn(arg_0));
    }
}

