/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.witchwater;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3852;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.util.RegistryEntryLists;

public class WitchWaterEntityRecipe
extends BaseRecipe<Context> {
    private final class_6885<class_1299<?>> target;
    @Nullable
    private final class_3852 profession;
    private final class_1299<?> result;

    public WitchWaterEntityRecipe(class_2960 id, class_6885<class_1299<?>> target, @Nullable class_3852 profession, class_1299<?> result) {
        super(id);
        this.target = target;
        this.profession = profession;
        this.result = result;
    }

    public static Optional<WitchWaterEntityRecipe> find(class_1297 entity, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.WITCH_WATER_ENTITY, (class_1263)new Context(entity), world);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(Context context, class_1937 world) {
        if (!this.target.method_40241((class_6880)context.entity.method_5864().method_40124())) {
            return false;
        }
        class_1297 class_12972 = context.entity;
        if (!(class_12972 instanceof class_1646)) return true;
        class_1646 villager = (class_1646)class_12972;
        if (this.profession == null) return true;
        if (villager.method_7231().method_16924() != this.profession) return false;
        return true;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.WITCH_WATER_ENTITY_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.WITCH_WATER_ENTITY;
    }

    @Override
    public class_1799 getDisplayStack() {
        class_1826 egg = class_1826.method_8019(this.result);
        return egg == null ? class_1799.field_8037 : egg.method_7854();
    }

    public class_6885<class_1299<?>> getTarget() {
        return this.target;
    }

    public class_1299<?> getResult() {
        return this.result;
    }

    @Nullable
    public class_3852 getProfession() {
        return this.profession;
    }

    protected record Context(class_1297 entity) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<WitchWaterEntityRecipe> {
        public WitchWaterEntityRecipe read(class_2960 id, JsonObject json) {
            class_6885 target = RegistryEntryLists.fromJson(class_2378.field_25107, json.get("target"));
            class_3852 profession = json.has("profession") ? (class_3852)class_2378.field_17167.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"profession"))) : null;
            class_1299 result = (class_1299)class_2378.field_11145.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"result")));
            return new WitchWaterEntityRecipe(id, target, profession, result);
        }

        public WitchWaterEntityRecipe read(class_2960 id, class_2540 buf) {
            class_6885 target = RegistryEntryLists.fromPacket(class_2378.field_25107, buf);
            class_3852 profession = buf.readBoolean() ? (class_3852)class_2378.field_17167.method_10223(buf.method_10810()) : null;
            class_1299 result = (class_1299)class_2378.field_11145.method_10223(buf.method_10810());
            return new WitchWaterEntityRecipe(id, target, profession, result);
        }

        public void write(class_2540 buf, WitchWaterEntityRecipe recipe) {
            RegistryEntryLists.toPacket(class_2378.field_25107, recipe.target, buf);
            buf.writeBoolean(recipe.profession != null);
            if (recipe.profession != null) {
                buf.method_10812(class_2378.field_17167.method_10221((Object)recipe.profession));
            }
            buf.method_10812(class_2378.field_11145.method_10221(recipe.result));
        }
    }
}

