/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.util;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3545;
import net.minecraft.class_5819;
import wraith.fabricaeexnihilo.util.ItemUtils;

public class WeightedList {
    public static final Codec<WeightedList> CODEC = Codec.unboundedMap((Codec)class_2378.field_11146.method_39673(), (Codec)Codec.INT).xmap(WeightedList::new, WeightedList::getValues);
    private final Map<class_2248, Integer> values;
    private int totalWeight;

    public WeightedList(Map<class_2248, Integer> values) {
        this.values = values;
        this.setTotalWeight();
    }

    public WeightedList(List<class_3545<class_2248, Integer>> values) {
        this.values = new HashMap<class_2248, Integer>();
        for (class_3545<class_2248, Integer> value : values) {
            this.values.put((class_2248)value.method_15442(), (Integer)value.method_15441());
        }
        this.setTotalWeight();
    }

    public Map<class_2248, Integer> getValues() {
        return this.values;
    }

    private void setTotalWeight() {
        this.totalWeight = this.values.values().stream().mapToInt(Integer::intValue).sum();
    }

    public class_2248 choose(class_5819 random) {
        int rem = random.method_43048(this.totalWeight + 1);
        class_2248 block = null;
        for (Map.Entry<class_2248, Integer> entry : this.values.entrySet()) {
            block = entry.getKey();
            if ((rem -= entry.getValue().intValue()) > 0) continue;
            break;
        }
        return block;
    }

    public List<class_1799> asListOfStacks() {
        return this.values.entrySet().stream().map(item -> ItemUtils.asStack((class_1935)item.getKey(), (Integer)item.getValue())).toList();
    }

    public <U> List<U> flatten(Function<class_2248, U> func) {
        return this.values.keySet().stream().map(func).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedList that = (WeightedList)o;
        return this.values.equals(that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

