/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.crucible;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class CrucibleRecipe
extends BaseRecipe<Context> {
    private final class_1856 input;
    private final long amount;
    private final FluidVariant fluid;
    private final boolean requiresFireproofCrucible;

    public CrucibleRecipe(class_2960 id, class_1856 input, long amount, FluidVariant fluid, boolean requiresFireproofCrucible) {
        super(id);
        this.input = input;
        this.amount = amount;
        this.fluid = fluid;
        this.requiresFireproofCrucible = requiresFireproofCrucible;
    }

    public static Optional<CrucibleRecipe> find(class_1799 input, boolean isFireproof, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.CRUCIBLE, (class_1263)new Context(input, isFireproof), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.input.method_8093(context.input) && (!this.requiresFireproofCrucible || context.isFireproof);
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.fluid.getFluid().method_15774().method_7854();
    }

    public boolean requiresFireproofCrucible() {
        return this.requiresFireproofCrucible;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.CRUCIBLE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.CRUCIBLE;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public long getAmount() {
        return this.amount;
    }

    public FluidVariant getFluid() {
        return this.fluid;
    }

    protected record Context(class_1799 input, boolean isFireproof) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<CrucibleRecipe> {
        public CrucibleRecipe read(class_2960 id, JsonObject json) {
            class_1856 input = class_1856.method_8102((JsonElement)json.get("input"));
            long amount = class_3518.method_22449((JsonObject)json, (String)"amount");
            FluidVariant fluid = CodecUtils.fromJson(CodecUtils.FLUID_VARIANT, json.get("fluid"));
            boolean isFireproof = class_3518.method_15270((JsonObject)json, (String)"requiresFireproofCrucible");
            return new CrucibleRecipe(id, input, amount, fluid, isFireproof);
        }

        public CrucibleRecipe read(class_2960 id, class_2540 buf) {
            class_1856 input = class_1856.method_8086((class_2540)buf);
            long amount = buf.readLong();
            FluidVariant fluid = CodecUtils.fromPacket(CodecUtils.FLUID_VARIANT, buf);
            boolean isFireproof = buf.readBoolean();
            return new CrucibleRecipe(id, input, amount, fluid, isFireproof);
        }

        public void write(class_2540 buf, CrucibleRecipe recipe) {
            recipe.input.method_8088(buf);
            buf.writeLong(recipe.amount);
            CodecUtils.toPacket(CodecUtils.FLUID_VARIANT, recipe.fluid, buf);
            buf.writeBoolean(recipe.requiresFireproofCrucible);
        }
    }
}

