/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonObject;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.util.CodecUtils;
import wraith.fabricaeexnihilo.util.RegistryEntryLists;

public class MilkingRecipe
extends BaseRecipe<Context> {
    private final class_6885<class_1299<?>> entity;
    private final FluidVariant fluid;
    private final long amount;
    private final int cooldown;

    public MilkingRecipe(class_2960 id, class_6885<class_1299<?>> entity, FluidVariant fluid, long amount, int cooldown) {
        super(id);
        this.entity = entity;
        this.fluid = fluid;
        this.amount = amount;
        this.cooldown = cooldown;
    }

    public static Optional<MilkingRecipe> find(class_1299<?> entity, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.MILKING, (class_1263)new Context(entity), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.entity.method_40241((class_6880)context.entity.method_40124());
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.fluid.getFluid().method_15774().method_7854();
    }

    public FluidVariant getFluid() {
        return this.fluid;
    }

    public long getAmount() {
        return this.amount;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.MILKING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.MILKING;
    }

    public class_6885<class_1299<?>> getEntity() {
        return this.entity;
    }

    protected record Context(class_1299<?> entity) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<MilkingRecipe> {
        public MilkingRecipe read(class_2960 id, JsonObject json) {
            class_6885 entity = RegistryEntryLists.fromJson(class_2378.field_25107, json.get("entity"));
            FluidVariant fluid = CodecUtils.fromJson(CodecUtils.FLUID_VARIANT, json.get("fluid"));
            long amount = json.get("amount").getAsLong();
            int cooldown = json.get("cooldown").getAsInt();
            return new MilkingRecipe(id, entity, fluid, amount, cooldown);
        }

        public MilkingRecipe read(class_2960 id, class_2540 buf) {
            class_6885 entity = RegistryEntryLists.fromPacket(class_2378.field_25107, buf);
            FluidVariant fluid = CodecUtils.fromPacket(CodecUtils.FLUID_VARIANT, buf);
            long amount = buf.readLong();
            int cooldown = buf.readInt();
            return new MilkingRecipe(id, entity, fluid, amount, cooldown);
        }

        public void write(class_2540 buf, MilkingRecipe recipe) {
            RegistryEntryLists.toPacket(class_2378.field_25107, recipe.entity, buf);
            CodecUtils.toPacket(CodecUtils.FLUID_VARIANT, recipe.fluid, buf);
            buf.writeLong(recipe.amount);
            buf.writeInt(recipe.cooldown);
        }
    }
}

