/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonObject;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.util.CodecUtils;
import wraith.fabricaeexnihilo.util.RegistryEntryLists;

public class FluidTransformationRecipe
extends BaseRecipe<Context> {
    private final class_6885<class_3611> fluid;
    private final class_6885<class_2248> catalyst;
    private final BarrelMode result;

    public FluidTransformationRecipe(class_2960 id, class_6885<class_3611> fluid, class_6885<class_2248> catalyst, BarrelMode result) {
        super(id);
        this.fluid = fluid;
        this.catalyst = catalyst;
        this.result = result;
    }

    public static Optional<FluidTransformationRecipe> find(FluidVariant contained, class_2248 catalyst, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.FLUID_TRANSFORMATION, (class_1263)new Context(contained, catalyst), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.fluid.method_40241((class_6880)context.contained.getFluid().method_40178()) && this.catalyst.method_40241((class_6880)context.catalyst.method_40142());
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.result.getReiResult().stream().map(EntryStack::cheatsAs).map(EntryStack::getValue).findFirst().orElse(class_1799.field_8037);
    }

    public class_1865<?> method_8119() {
        return ModRecipes.FLUID_TRANSFORMATION_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.FLUID_TRANSFORMATION;
    }

    public BarrelMode getResult() {
        return this.result;
    }

    public class_6885<class_3611> getFluid() {
        return this.fluid;
    }

    public class_6885<class_2248> getCatalyst() {
        return this.catalyst;
    }

    protected record Context(FluidVariant contained, class_2248 catalyst) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<FluidTransformationRecipe> {
        public FluidTransformationRecipe read(class_2960 id, JsonObject json) {
            class_6885 fluid = RegistryEntryLists.fromJson(class_2378.field_25103, json.get("fluid"));
            class_6885 catalyst = RegistryEntryLists.fromJson(class_2378.field_25105, json.get("catalyst"));
            BarrelMode result = CodecUtils.fromJson(BarrelMode.CODEC, json.get("result"));
            return new FluidTransformationRecipe(id, fluid, catalyst, result);
        }

        public FluidTransformationRecipe read(class_2960 id, class_2540 buf) {
            class_6885 fluid = RegistryEntryLists.fromPacket(class_2378.field_25103, buf);
            class_6885 catalyst = RegistryEntryLists.fromPacket(class_2378.field_25105, buf);
            BarrelMode result = CodecUtils.fromPacket(BarrelMode.CODEC, buf);
            return new FluidTransformationRecipe(id, fluid, catalyst, result);
        }

        public void write(class_2540 buf, FluidTransformationRecipe recipe) {
            RegistryEntryLists.toPacket(class_2378.field_25103, recipe.fluid, buf);
            RegistryEntryLists.toPacket(class_2378.field_25105, recipe.catalyst, buf);
            CodecUtils.toPacket(BarrelMode.CODEC, recipe.result, buf);
        }
    }
}

