/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonObject;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.util.CodecUtils;
import wraith.fabricaeexnihilo.util.RegistryEntryLists;

public class FluidCombinationRecipe
extends BaseRecipe<Context> {
    private final class_6885<class_3611> contained;
    private final class_6885<class_3611> other;
    private final BarrelMode result;

    public FluidCombinationRecipe(class_2960 id, class_6885<class_3611> contained, class_6885<class_3611> other, BarrelMode result) {
        super(id);
        this.contained = contained;
        this.other = other;
        this.result = result;
    }

    public static Optional<FluidCombinationRecipe> find(FluidVariant contained, FluidVariant other, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.FLUID_COMBINATION, (class_1263)new Context(contained, other), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.contained.method_40241((class_6880)context.contained.getFluid().method_40178()) && this.other.method_40241((class_6880)context.other.getFluid().method_40178());
    }

    @Override
    public class_1799 getDisplayStack() {
        EntryIngredient reiResult = this.result.getReiResult();
        return reiResult.size() > 0 ? (class_1799)((EntryStack)reiResult.get(0)).cheatsAs().getValue() : class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.FLUID_COMBINATION_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.FLUID_COMBINATION;
    }

    public BarrelMode getResult() {
        return this.result;
    }

    public class_6885<class_3611> getContained() {
        return this.contained;
    }

    public class_6885<class_3611> getOther() {
        return this.other;
    }

    protected record Context(FluidVariant contained, FluidVariant other) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<FluidCombinationRecipe> {
        public FluidCombinationRecipe read(class_2960 id, JsonObject json) {
            class_6885 contained = RegistryEntryLists.fromJson(class_2378.field_25103, json.get("contained"));
            class_6885 other = RegistryEntryLists.fromJson(class_2378.field_25103, json.get("other"));
            BarrelMode result = CodecUtils.fromJson(BarrelMode.CODEC, json.get("result"));
            return new FluidCombinationRecipe(id, contained, other, result);
        }

        public FluidCombinationRecipe read(class_2960 id, class_2540 buf) {
            class_6885 contained = RegistryEntryLists.fromPacket(class_2378.field_25103, buf);
            class_6885 other = RegistryEntryLists.fromPacket(class_2378.field_25103, buf);
            BarrelMode result = CodecUtils.fromPacket(BarrelMode.CODEC, buf);
            return new FluidCombinationRecipe(id, contained, other, result);
        }

        public void write(class_2540 buf, FluidCombinationRecipe recipe) {
            RegistryEntryLists.toPacket(class_2378.field_25103, recipe.contained, buf);
            RegistryEntryLists.toPacket(class_2378.field_25103, recipe.other, buf);
            CodecUtils.toPacket(BarrelMode.CODEC, recipe.result, buf);
        }
    }
}

