/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.EmptyMode;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.recipe.util.EntityStack;
import wraith.fabricaeexnihilo.recipe.util.Loot;
import wraith.fabricaeexnihilo.util.CodecUtils;
import wraith.fabricaeexnihilo.util.RegistryEntryLists;

public class AlchemyRecipe
extends BaseRecipe<Context> {
    private final class_6885<class_3611> reactant;
    private final class_1856 catalyst;
    private final Loot byproduct;
    private final int delay;
    private final EntityStack toSpawn;
    private final BarrelMode result;

    public AlchemyRecipe(class_2960 id, class_6885<class_3611> reactant, class_1856 catalyst, Loot byproduct, int delay, EntityStack toSpawn, BarrelMode result) {
        super(id);
        this.reactant = reactant;
        this.catalyst = catalyst;
        this.byproduct = byproduct;
        this.delay = delay;
        this.toSpawn = toSpawn;
        this.result = result;
    }

    public static Optional<AlchemyRecipe> find(FluidVariant reactant, class_1799 catalyst, @Nullable class_1937 world) {
        if (world == null) {
            return Optional.empty();
        }
        return world.method_8433().method_8132(ModRecipes.ALCHEMY, (class_1263)new Context(reactant, catalyst), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.reactant.method_40241((class_6880)context.reactant.getFluid().method_40178()) && this.catalyst.method_8093(context.catalyst);
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.byproduct.stack();
    }

    public class_1865<?> method_8119() {
        return ModRecipes.ALCHEMY_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.ALCHEMY;
    }

    public class_6885<class_3611> getReactant() {
        return this.reactant;
    }

    public class_1856 getCatalyst() {
        return this.catalyst;
    }

    public Loot getByproduct() {
        return this.byproduct;
    }

    public int getDelay() {
        return this.delay;
    }

    public EntityStack getToSpawn() {
        return this.toSpawn;
    }

    public BarrelMode getResult() {
        return this.result;
    }

    protected record Context(FluidVariant reactant, class_1799 catalyst) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<AlchemyRecipe> {
        public AlchemyRecipe read(class_2960 id, JsonObject json) {
            class_6885 reactant = RegistryEntryLists.fromJson(class_2378.field_25103, json.get("reactant"));
            class_1856 catalyst = class_1856.method_8102((JsonElement)json.get("catalyst"));
            Loot byproduct = json.has("byproduct") ? CodecUtils.fromJson(Loot.CODEC, json.get("byproduct")) : Loot.EMPTY;
            int delay = class_3518.method_15282((JsonObject)json, (String)"delay", (int)0);
            EntityStack toSpawn = json.has("toSpawn") ? CodecUtils.fromJson(EntityStack.CODEC, json.get("toSpawn")) : EntityStack.EMPTY;
            EmptyMode result = json.has("result") ? CodecUtils.fromJson(BarrelMode.CODEC, json.get("result")) : new EmptyMode();
            return new AlchemyRecipe(id, reactant, catalyst, byproduct, delay, toSpawn, result);
        }

        public AlchemyRecipe read(class_2960 id, class_2540 buf) {
            class_6885 reactant = RegistryEntryLists.fromPacket(class_2378.field_25103, buf);
            class_1856 catalyst = class_1856.method_8086((class_2540)buf);
            Loot byproduct = CodecUtils.fromPacket(Loot.CODEC, buf);
            int delay = buf.readInt();
            EntityStack toSpawn = CodecUtils.fromPacket(EntityStack.CODEC, buf);
            BarrelMode result = CodecUtils.fromPacket(BarrelMode.CODEC, buf);
            return new AlchemyRecipe(id, reactant, catalyst, byproduct, delay, toSpawn, result);
        }

        public void write(class_2540 buf, AlchemyRecipe recipe) {
            RegistryEntryLists.toPacket(class_2378.field_25103, recipe.reactant, buf);
            recipe.catalyst.method_8088(buf);
            CodecUtils.toPacket(Loot.CODEC, recipe.byproduct, buf);
            buf.writeInt(recipe.delay);
            CodecUtils.toPacket(EntityStack.CODEC, recipe.toSpawn, buf);
            CodecUtils.toPacket(BarrelMode.CODEC, recipe.result, buf);
        }
    }
}

