/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.recipe.util.Loot;
import wraith.fabricaeexnihilo.util.CodecUtils;
import wraith.fabricaeexnihilo.util.RegistryEntryLists;

public class ToolRecipe
extends BaseRecipe<Context> {
    private final ToolType tool;
    private final class_6885<class_2248> block;
    private final Loot result;

    public ToolRecipe(class_2960 id, ToolType tool, class_6885<class_2248> block, Loot result) {
        super(id);
        this.tool = tool;
        this.block = block;
        this.result = result;
    }

    public static List<ToolRecipe> find(ToolType type, class_2248 block, @Nullable class_1937 world) {
        if (world == null) {
            return List.of();
        }
        return world.method_8433().method_17877(type.type, (class_1263)new Context(block), world);
    }

    @Override
    public boolean matches(Context context, class_1937 world) {
        return this.block.method_40241((class_6880)context.block.method_40142());
    }

    public class_1865<?> method_8119() {
        return this.tool.serializer;
    }

    public class_3956<?> method_17716() {
        return this.tool.type;
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.result.stack();
    }

    public ToolType getTool() {
        return this.tool;
    }

    public class_6885<class_2248> getBlock() {
        return this.block;
    }

    public Loot getResult() {
        return this.result;
    }

    public static enum ToolType {
        HAMMER(ModRecipes.HAMMER, ModRecipes.HAMMER_SERIALIZER),
        CROOK(ModRecipes.CROOK, ModRecipes.CROOK_SERIALIZER);

        public final class_3956<ToolRecipe> type;
        public final class_1865<?> serializer;

        private ToolType(class_3956<ToolRecipe> type, class_1865<?> serializer) {
            this.type = type;
            this.serializer = serializer;
        }

        public static ToolType fromRecipeType(String type) {
            return switch (type) {
                case "fabricaeexnihilo:hammer" -> HAMMER;
                case "fabricaeexnihilo:crook" -> CROOK;
                default -> throw new IllegalStateException("Tried to find tool type for unknown recipe type: " + type);
            };
        }
    }

    public record Context(class_2248 block) implements RecipeContext
    {
    }

    public static class Serializer
    implements class_1865<ToolRecipe> {
        public ToolRecipe read(class_2960 id, JsonObject json) {
            ToolType tool = ToolType.fromRecipeType(class_3518.method_15265((JsonObject)json, (String)"type"));
            class_6885 block = RegistryEntryLists.fromJson(class_2378.field_25105, json.get("block"));
            Loot result = CodecUtils.fromJson(Loot.CODEC, json.get("result"));
            return new ToolRecipe(id, tool, block, result);
        }

        public ToolRecipe read(class_2960 id, class_2540 buf) {
            ToolType tool = (ToolType)buf.method_10818(ToolType.class);
            class_6885 block = RegistryEntryLists.fromPacket(class_2378.field_25105, buf);
            Loot result = CodecUtils.fromPacket(Loot.CODEC, buf);
            return new ToolRecipe(id, tool, block, result);
        }

        public void write(class_2540 buf, ToolRecipe recipe) {
            buf.method_10817((Enum)recipe.tool);
            RegistryEntryLists.toPacket(class_2378.field_25105, recipe.block, buf);
            CodecUtils.toPacket(Loot.CODEC, recipe.result, buf);
        }
    }
}

