/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.crucibles;

import java.util.Iterator;
import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.base.BaseBlockEntity;
import wraith.fabricaeexnihilo.modules.base.EnchantableBlockEntity;
import wraith.fabricaeexnihilo.modules.base.EnchantmentContainer;
import wraith.fabricaeexnihilo.modules.crucibles.CrucibleBlock;
import wraith.fabricaeexnihilo.recipe.crucible.CrucibleHeatRecipe;
import wraith.fabricaeexnihilo.recipe.crucible.CrucibleRecipe;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class CrucibleBlockEntity
extends BaseBlockEntity
implements EnchantableBlockEntity {
    public static final class_2960 BLOCK_ENTITY_ID = FabricaeExNihilo.id("crucible");
    public static final class_2591<CrucibleBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(CrucibleBlockEntity::new, (class_2248[])((class_2248[])ModBlocks.CRUCIBLES.values().toArray(new CrucibleBlock[0]))).build(null);
    private final EnchantmentContainer enchantments = new EnchantmentContainer();
    private final Storage<FluidVariant> fluidStorage = new CrucibleFluidStorage();
    private final Storage<ItemVariant> itemStorage = new CrucibleItemStorage();
    private long contained = 0L;
    private FluidVariant fluid = FluidVariant.blank();
    private int heat = 0;
    private boolean requiresFireproof = false;
    private long queued = 0L;
    private class_1799 renderStack = class_1799.field_8037;
    private int tickCounter;

    public CrucibleBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
        this.tickCounter = this.field_11863 == null ? FabricaeExNihilo.CONFIG.modules.crucibles.tickRate : this.field_11863.field_9229.method_43048(FabricaeExNihilo.CONFIG.modules.crucibles.tickRate);
    }

    public static void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, CrucibleBlockEntity crucibleEntity) {
        crucibleEntity.tick();
    }

    public class_1269 activate(@Nullable class_1657 player, @Nullable class_1268 hand) {
        long amount;
        if (this.field_11863 == null || player == null) {
            return class_1269.field_5811;
        }
        class_1799 held = player.method_5998(hand == null ? player.method_6058() : hand);
        if (held == null || held.method_7960()) {
            return class_1269.field_5811;
        }
        Storage bucketFluidStorage = (Storage)FluidStorage.ITEM.find(held, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
        if (bucketFluidStorage != null && (amount = StorageUtil.move(this.fluidStorage, (Storage)bucketFluidStorage, fluid -> true, (long)Long.MAX_VALUE, null)) > 0L) {
            this.method_5431();
            return class_1269.field_5812;
        }
        try (Transaction t = Transaction.openOuter();){
            long amount2 = this.itemStorage.insert((Object)ItemVariant.of((class_1799)held), 1L, (TransactionContext)t);
            if (amount2 > 0L) {
                t.commit();
                if (!player.method_7337()) {
                    held.method_7934((int)amount2);
                }
                this.method_5431();
                class_1269 class_12692 = class_1269.field_5812;
                return class_12692;
            }
        }
        return class_1269.field_5811;
    }

    public long getContained() {
        return this.contained;
    }

    private int getEfficiencyMultiplier() {
        return 1 + this.enchantments.getEnchantmentLevel(class_1893.field_9131);
    }

    @Override
    public EnchantmentContainer getEnchantmentContainer() {
        return this.enchantments;
    }

    public EnchantmentContainer getEnchantments() {
        return this.enchantments;
    }

    private int getFireAspectAdder() {
        return this.enchantments.getEnchantmentLevel(class_1893.field_9124);
    }

    public FluidVariant getFluid() {
        return this.fluid;
    }

    public long getMaxCapacity() {
        return 81000L * (long)(this.isFireproof() ? FabricaeExNihilo.CONFIG.modules.crucibles.stoneVolume : FabricaeExNihilo.CONFIG.modules.crucibles.woodVolume);
    }

    public long getProcessingSpeed() {
        return (long)this.getEfficiencyMultiplier() * (this.isFireproof() ? (long)(this.requiresFireproof ? this.heat : 1) * FabricaeExNihilo.CONFIG.modules.crucibles.baseProcessRate : FabricaeExNihilo.CONFIG.modules.crucibles.woodenProcessingRate);
    }

    public long getQueued() {
        return this.queued;
    }

    public class_1799 getRenderStack() {
        return this.renderStack;
    }

    public boolean isFireproof() {
        CrucibleBlock crucible;
        class_2248 class_22482 = this.method_11010().method_26204();
        return class_22482 instanceof CrucibleBlock && (crucible = (CrucibleBlock)class_22482).isFireproof();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt == null) {
            FabricaeExNihilo.LOGGER.warn("A crucible at " + this.field_11867 + " is missing data.");
            return;
        }
        this.readNbtWithoutWorldInfo(nbt);
    }

    private void readNbtWithoutWorldInfo(class_2487 nbt) {
        this.renderStack = class_1799.method_7915((class_2487)nbt.method_10562("render"));
        this.fluid = CodecUtils.fromNbt(CodecUtils.FLUID_VARIANT, nbt.method_10580("fluid"));
        this.contained = nbt.method_10537("contained");
        this.queued = nbt.method_10537("queued");
        this.heat = nbt.method_10550("heat");
        boolean bl = this.requiresFireproof = !nbt.method_10545("requiresFireproof") || nbt.method_10577("requiresFireproof");
        if (nbt.method_10545("enchantments")) {
            EnchantmentContainer readEnchantments = new EnchantmentContainer();
            readEnchantments.readNbt(nbt.method_10562("enchantments"));
            this.enchantments.setAllEnchantments(readEnchantments);
        }
    }

    public void tick() {
        if (this.queued == 0L || this.contained > this.getMaxCapacity() || this.requiresFireproof && (this.heat <= 0 || !this.isFireproof())) {
            return;
        }
        if (--this.tickCounter <= 0) {
            long amount = Math.min(this.queued, this.getProcessingSpeed());
            this.contained += amount;
            this.queued -= amount;
            this.method_5431();
            this.tickCounter = FabricaeExNihilo.CONFIG.modules.crucibles.tickRate;
        }
    }

    public void updateHeat() {
        if (this.field_11863 == null) {
            return;
        }
        int oldHeat = this.heat;
        class_2680 state = this.field_11863.method_8320(this.field_11867.method_10074());
        class_2248 block = state.method_26204();
        this.heat = CrucibleHeatRecipe.find(block, this.field_11863).map(CrucibleHeatRecipe::getHeat).orElse(0);
        if (block instanceof class_2404) {
            this.heat = (int)((float)this.heat * state.method_26227().method_20785());
        }
        this.heat += this.getFireAspectAdder();
        if (this.heat != oldHeat) {
            this.method_5431();
        }
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.writeNbtWithoutWorldInfo(nbt);
    }

    private void writeNbtWithoutWorldInfo(class_2487 nbt) {
        nbt.method_10566("render", (class_2520)this.renderStack.method_7953(new class_2487()));
        nbt.method_10566("fluid", CodecUtils.toNbt(CodecUtils.FLUID_VARIANT, this.fluid));
        nbt.method_10544("contained", this.contained);
        nbt.method_10544("queued", this.queued);
        nbt.method_10569("heat", this.heat);
        nbt.method_10556("requiresFireproof", this.requiresFireproof);
        nbt.method_10566("enchantments", (class_2520)this.enchantments.writeNbt());
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((crucible, direction) -> crucible.itemStorage, TYPE);
        FluidStorage.SIDED.registerForBlockEntity((crucible, direction) -> crucible.fluidStorage, TYPE);
    }

    private class CrucibleFluidStorage
    extends SnapshotParticipant<CrucibleSnapshot>
    implements SingleSlotStorage<FluidVariant>,
    ExtractionOnlyStorage<FluidVariant> {
        private CrucibleFluidStorage() {
        }

        protected CrucibleSnapshot createSnapshot() {
            return new CrucibleSnapshot(CrucibleBlockEntity.this.contained, CrucibleBlockEntity.this.queued, CrucibleBlockEntity.this.fluid, CrucibleBlockEntity.this.requiresFireproof, CrucibleBlockEntity.this.renderStack);
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (!resource.equals(CrucibleBlockEntity.this.fluid)) {
                return 0L;
            }
            long amount = Math.min(maxAmount, CrucibleBlockEntity.this.contained);
            this.updateSnapshots(transaction);
            CrucibleBlockEntity.this.contained -= amount;
            return amount;
        }

        public long getAmount() {
            return CrucibleBlockEntity.this.contained;
        }

        public long getCapacity() {
            return CrucibleBlockEntity.this.getMaxCapacity();
        }

        public FluidVariant getResource() {
            return CrucibleBlockEntity.this.fluid;
        }

        public boolean isResourceBlank() {
            return CrucibleBlockEntity.this.fluid.isBlank();
        }

        protected void readSnapshot(CrucibleSnapshot snapshot) {
            CrucibleBlockEntity.this.contained = snapshot.contained;
            CrucibleBlockEntity.this.queued = snapshot.queued;
            CrucibleBlockEntity.this.fluid = snapshot.fluid;
            CrucibleBlockEntity.this.requiresFireproof = snapshot.requiresFireproof;
            CrucibleBlockEntity.this.renderStack = snapshot.renderStack.method_7972();
        }
    }

    private class CrucibleItemStorage
    extends SnapshotParticipant<CrucibleSnapshot>
    implements InsertionOnlyStorage<ItemVariant>,
    SingleSlotStorage<ItemVariant> {
        private CrucibleItemStorage() {
        }

        protected CrucibleSnapshot createSnapshot() {
            return new CrucibleSnapshot(CrucibleBlockEntity.this.contained, CrucibleBlockEntity.this.queued, CrucibleBlockEntity.this.fluid, CrucibleBlockEntity.this.requiresFireproof, CrucibleBlockEntity.this.renderStack.method_7972());
        }

        public long getAmount() {
            return 0L;
        }

        public long getCapacity() {
            return 1L;
        }

        public ItemVariant getResource() {
            return ItemVariant.blank();
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            Optional<CrucibleRecipe> recipeOptional = CrucibleRecipe.find(resource.toStack(), CrucibleBlockEntity.this.isFireproof(), CrucibleBlockEntity.this.field_11863);
            if (recipeOptional.isEmpty()) {
                return 0L;
            }
            CrucibleRecipe recipe = recipeOptional.get();
            if (!recipe.getFluid().equals(CrucibleBlockEntity.this.fluid) && !CrucibleBlockEntity.this.fluid.isBlank()) {
                return 0L;
            }
            long amount = Math.min(recipe.getAmount(), CrucibleBlockEntity.this.getMaxCapacity() - CrucibleBlockEntity.this.contained - CrucibleBlockEntity.this.queued);
            if (amount == 0L) {
                return 0L;
            }
            this.updateSnapshots(transaction);
            CrucibleBlockEntity.this.fluid = recipe.getFluid();
            CrucibleBlockEntity.this.queued += amount;
            CrucibleBlockEntity.this.requiresFireproof = recipe.requiresFireproofCrucible();
            CrucibleBlockEntity.this.renderStack = resource.toStack();
            return 1L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return super.extract((Object)resource, maxAmount, transaction);
        }

        public boolean isResourceBlank() {
            return true;
        }

        protected void readSnapshot(CrucibleSnapshot snapshot) {
            CrucibleBlockEntity.this.contained = snapshot.contained;
            CrucibleBlockEntity.this.queued = snapshot.queued;
            CrucibleBlockEntity.this.fluid = snapshot.fluid;
            CrucibleBlockEntity.this.requiresFireproof = snapshot.requiresFireproof;
            CrucibleBlockEntity.this.renderStack = snapshot.renderStack.method_7972();
        }

        @NotNull
        public Iterator<StorageView<ItemVariant>> iterator() {
            return super.iterator();
        }
    }

    private record CrucibleSnapshot(long contained, long queued, FluidVariant fluid, boolean requiresFireproof, class_1799 renderStack) {
    }
}

