/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels.modes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelFluidStorage;
import wraith.fabricaeexnihilo.modules.barrels.BarrelItemStorage;
import wraith.fabricaeexnihilo.modules.barrels.modes.AlchemyMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.EmptyMode;
import wraith.fabricaeexnihilo.recipe.barrel.AlchemyRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.FluidCombinationRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.FluidTransformationRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.LeakingRecipe;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class FluidMode
extends BarrelMode {
    public static final Codec<FluidMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.FLUID_VARIANT.fieldOf("fluid").forGetter(FluidMode::getFluid), (App)Codec.LONG.fieldOf("amount").forGetter(FluidMode::getAmount)).apply((Applicative)instance, FluidMode::new));
    private final FluidVariant fluid;
    private long amount;

    public FluidMode(FluidVariant fluid, long amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    @Override
    public BarrelMode copy() {
        return new FluidMode(this.fluid, this.amount);
    }

    @Override
    public EntryIngredient getReiResult() {
        return EntryIngredients.of((class_3611)this.fluid.getFluid(), (long)this.amount);
    }

    @Override
    public long extractFluid(FluidVariant fluid, long maxAmount, TransactionContext transaction, BarrelFluidStorage storage) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluid, (long)maxAmount);
        if (!this.fluid.equals(fluid)) {
            return 0L;
        }
        long amount = Math.min(maxAmount, this.amount);
        storage.updateSnapshots(transaction);
        this.amount -= amount;
        if (this.amount == 0L) {
            storage.barrel.setMode(new EmptyMode());
        }
        return amount;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public FluidVariant getFluid() {
        return this.fluid;
    }

    @Override
    public long getFluidAmount() {
        return this.amount;
    }

    @Override
    public long getFluidCapacity() {
        return 81000L;
    }

    @Override
    public String getId() {
        return "fluid";
    }

    @Override
    public long getItemCapacity() {
        return 1L;
    }

    @Override
    public long insertFluid(FluidVariant fluid, long maxAmount, TransactionContext transaction, BarrelFluidStorage storage) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluid, (long)maxAmount);
        if (!this.fluid.equals(fluid)) {
            return 0L;
        }
        long amount = Math.min(81000L - this.amount, maxAmount);
        storage.updateSnapshots(transaction);
        this.amount += amount;
        return amount;
    }

    @Override
    public long insertItem(ItemVariant item, long maxAmount, TransactionContext transaction, BarrelItemStorage storage) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)item, (long)maxAmount);
        Optional<AlchemyRecipe> result = AlchemyRecipe.find(this.fluid, item.toStack(), storage.barrel.method_10997());
        if (result.isEmpty() || !FabricaeExNihilo.CONFIG.modules.barrels.enableAlchemy) {
            return 0L;
        }
        storage.updateSnapshots(transaction);
        storage.barrel.setMode(new AlchemyMode(this, result.get()));
        return 1L;
    }

    @Override
    public void precipitationTick(BarrelBlockEntity barrel, class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382 && this.fluid.isOf((Object)class_3612.field_15910) && this.amount < this.getFluidCapacity()) {
            this.amount += 810L;
            if (this.amount >= this.getFluidCapacity()) {
                this.amount = this.getFluidCapacity();
            }
        }
    }

    @Override
    public void tick(BarrelBlockEntity barrel) {
        FabricaeExNihiloConfig.ModuleConfig.BarrelConfig config = FabricaeExNihilo.CONFIG.modules.barrels;
        class_1937 world = barrel.method_10997();
        class_2338 pos = barrel.method_11016();
        if (this.amount >= 81000L) {
            class_2248 block;
            Optional<FluidTransformationRecipe> recipe;
            class_2680 blockState;
            class_3610 fluidState = world.method_8316(pos.method_10084());
            if (!fluidState.method_15769() && config.enableFluidCombination && fluidState.method_15771()) {
                class_3611 fluid = fluidState.method_15772();
                Optional<FluidCombinationRecipe> recipe2 = FluidCombinationRecipe.find(this.fluid, FluidVariant.of((class_3611)fluid), world);
                recipe2.ifPresent(fluidCombinationRecipe -> barrel.setMode(fluidCombinationRecipe.getResult().copy()));
            }
            if (!(blockState = world.method_8320(pos.method_10074())).method_26215() && config.transforming.enabled && (recipe = FluidTransformationRecipe.find(this.fluid, block = blockState.method_26204(), world)).isPresent()) {
                int num = barrel.countBelow(block, config.transforming.boostRadius);
                barrel.setMode(new AlchemyMode(this, recipe.get().getResult().copy(), config.transforming.rate - (num - 1) * config.transforming.boost));
            }
        }
        if (!config.leaking.enabled) {
            return;
        }
        if (barrel.isFireproof()) {
            return;
        }
        class_2338 leakPos = barrel.getLeakPos();
        if (leakPos == null) {
            return;
        }
        Optional<LeakingRecipe> recipe = LeakingRecipe.find(world.method_8320(leakPos).method_26204(), this.fluid, world);
        if (recipe.isEmpty()) {
            return;
        }
        long leakAmount = recipe.get().getAmount();
        world.method_8501(leakPos, recipe.get().getResult().method_9564());
        if (this.amount >= leakAmount) {
            this.amount -= leakAmount;
        } else {
            barrel.setMode(new EmptyMode());
        }
    }
}

