/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels.modes;

import com.mojang.serialization.Codec;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1959;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.modules.ModTags;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelFluidStorage;
import wraith.fabricaeexnihilo.modules.barrels.BarrelItemStorage;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.CompostMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.FluidMode;
import wraith.fabricaeexnihilo.recipe.barrel.CompostRecipe;

public class EmptyMode
extends BarrelMode {
    public static final Codec<EmptyMode> CODEC = Codec.unit((Object)new EmptyMode());

    @Override
    public String getId() {
        return "empty";
    }

    @Override
    public BarrelMode copy() {
        return new EmptyMode();
    }

    @Override
    public EntryIngredient getReiResult() {
        return EntryIngredient.empty();
    }

    @Override
    public void precipitationTick(BarrelBlockEntity barrel, class_1959.class_1963 precipitation) {
        if (precipitation == class_1959.class_1963.field_9382) {
            barrel.setMode(new FluidMode(FluidVariant.of((class_3611)class_3612.field_15910), 810L));
        }
    }

    @Override
    public long insertItem(ItemVariant item, long maxAmount, TransactionContext transaction, BarrelItemStorage storage) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)item, (long)maxAmount);
        Optional<CompostRecipe> recipe = CompostRecipe.find(item.toStack(), storage.barrel.method_10997());
        if (recipe.isEmpty() || !FabricaeExNihilo.CONFIG.modules.barrels.compost.enabled) {
            return 0L;
        }
        storage.updateSnapshots(transaction);
        storage.barrel.setMode(new CompostMode(recipe.get()));
        return 1L;
    }

    @Override
    public long getItemCapacity() {
        return 1L;
    }

    @Override
    public long insertFluid(FluidVariant fluid, long maxAmount, TransactionContext transaction, BarrelFluidStorage storage) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluid, (long)maxAmount);
        if (fluid.getFluid().method_15791(ModTags.HOT) && !storage.barrel.isFireproof()) {
            return 0L;
        }
        long amount = Math.min(maxAmount, 81000L);
        storage.updateSnapshots(transaction);
        storage.barrel.setMode(new FluidMode(fluid, amount));
        return amount;
    }

    @Override
    public long getFluidCapacity() {
        return 81000L;
    }
}

