/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels.modes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelItemStorage;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.ItemMode;
import wraith.fabricaeexnihilo.recipe.barrel.CompostRecipe;
import wraith.fabricaeexnihilo.util.CodecUtils;
import wraith.fabricaeexnihilo.util.Color;

public class CompostMode
extends BarrelMode {
    public static final Codec<CompostMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.ITEM_STACK.fieldOf("result").forGetter(CompostMode::getResult), (App)Codec.DOUBLE.fieldOf("amount").forGetter(CompostMode::getAmount), (App)Codec.DOUBLE.fieldOf("progress").forGetter(CompostMode::getProgress), (App)Color.CODEC.fieldOf("color").forGetter(CompostMode::getColor)).apply((Applicative)instance, CompostMode::new));
    private final class_1799 result;
    private double progress;
    private double amount;
    private Color color;

    public CompostMode(CompostRecipe recipe) {
        this(recipe.getResult(), recipe.getIncrement(), recipe.getColor());
    }

    public CompostMode(class_1799 result, double amount, Color color) {
        this(result, amount, 0.0, color);
    }

    private CompostMode(class_1799 result, double amount, double progress, Color color) {
        this.result = result;
        this.amount = amount;
        this.color = color;
        this.progress = progress;
    }

    @Override
    public String getId() {
        return "compost";
    }

    @Override
    public BarrelMode copy() {
        return new CompostMode(this.result.method_7972(), this.amount, this.progress, this.color);
    }

    @Override
    public EntryIngredient getReiResult() {
        return EntryIngredients.of((class_1799)this.result).map(stack -> stack.tooltip(new class_2561[]{class_2561.method_43470((String)"%d%%".formatted((int)this.amount * 100))}));
    }

    @Override
    public void tick(BarrelBlockEntity barrel) {
        if (this.progress >= 1.0) {
            barrel.setMode(new ItemMode(this.result.method_7972()));
        } else if (this.amount >= 1.0) {
            this.progress += FabricaeExNihilo.CONFIG.modules.barrels.compost.rate * (double)barrel.getEfficiencyMultiplier();
            barrel.method_5431();
        }
    }

    public double getProgress() {
        return this.progress;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public double getAmount() {
        return this.amount;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public long insertItem(ItemVariant item, long maxAmount, TransactionContext transaction, BarrelItemStorage storage) {
        Optional<CompostRecipe> recipe = CompostRecipe.find(item.toStack(), storage.barrel.method_10997());
        storage.updateSnapshots(transaction);
        if (recipe.isPresent() && this.amount < 1.0 && recipe.get().getResult().method_7929(this.result)) {
            this.amount = Math.min(this.amount + recipe.get().getIncrement(), 1.0);
            this.color = recipe.get().getColor();
            this.progress = 0.0;
            return 1L;
        }
        return 0L;
    }

    @Override
    public long getItemCapacity() {
        return 1L;
    }
}

