/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels.modes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.recipe.barrel.AlchemyRecipe;
import wraith.fabricaeexnihilo.recipe.util.EntityStack;
import wraith.fabricaeexnihilo.recipe.util.Loot;

public class AlchemyMode
extends BarrelMode {
    public static final Codec<AlchemyMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BarrelMode.CODEC.fieldOf("before").forGetter(AlchemyMode::getBefore), (App)BarrelMode.CODEC.fieldOf("after").forGetter(AlchemyMode::getAfter), (App)EntityStack.CODEC.fieldOf("toSpawn").forGetter(AlchemyMode::getToSpawn), (App)Codec.INT.fieldOf("duration").forGetter(AlchemyMode::getDuration), (App)Codec.INT.optionalFieldOf("progress").forGetter(mode -> Optional.of(mode.progress)), (App)Loot.CODEC.optionalFieldOf("byproduct").forGetter(mode -> Optional.ofNullable(mode.byproduct))).apply((Applicative)instance, (before, after, toSpawn, duration, progress, byproduct) -> {
        AlchemyMode mode = new AlchemyMode((BarrelMode)before, (BarrelMode)after, (EntityStack)toSpawn, progress.orElse(0), (int)duration);
        mode.byproduct = byproduct.orElse(null);
        return mode;
    }));
    private final BarrelMode before;
    private final BarrelMode after;
    private final EntityStack toSpawn;
    private int progress;
    private final int duration;
    @Nullable
    private Loot byproduct;

    public AlchemyMode(BarrelMode before, AlchemyRecipe recipe) {
        this(before, recipe.getResult().copy(), recipe.getToSpawn().copy(), recipe.getDelay());
        this.byproduct = recipe.getByproduct();
    }

    public AlchemyMode(BarrelMode before, BarrelMode after, int duration) {
        this(before, after, EntityStack.EMPTY, duration);
    }

    public AlchemyMode(BarrelMode before, BarrelMode after, EntityStack toSpawn, int duration) {
        this(before, after, toSpawn, 0, duration);
    }

    public AlchemyMode(BarrelMode before, BarrelMode after, EntityStack toSpawn, int progress, int duration) {
        this.before = before;
        this.after = after;
        this.toSpawn = toSpawn;
        this.progress = progress;
        this.duration = duration;
    }

    @Override
    @NotNull
    public String getId() {
        return "alchemy";
    }

    @Override
    public BarrelMode copy() {
        return new AlchemyMode(this.before.copy(), this.after.copy(), this.toSpawn.copy(), this.progress, this.duration);
    }

    @Override
    public EntryIngredient getReiResult() {
        BarrelMode checking = this.after;
        while (checking instanceof AlchemyMode) {
            AlchemyMode alchemyMode = (AlchemyMode)checking;
            checking = alchemyMode.after;
            if (checking != this) continue;
            FabricaeExNihilo.LOGGER.warn("Recursive alchemy mode detected");
            return EntryIngredient.empty();
        }
        return checking.getReiResult();
    }

    @Override
    public void tick(BarrelBlockEntity barrel) {
        this.progress += barrel.getEfficiencyMultiplier();
        class_1937 world = barrel.method_10997();
        if (world != null && !world.field_9236 && this.progress >= this.duration) {
            if (this.byproduct != null) {
                barrel.spawnByproduct(this.byproduct.createStack(world.field_9229));
                this.byproduct = null;
            }
            barrel.spawnEntity(this.toSpawn);
            barrel.setMode(this.after);
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public int getProgress() {
        return this.progress;
    }

    public BarrelMode getBefore() {
        return this.before;
    }

    public BarrelMode getAfter() {
        return this.after;
    }

    public EntityStack getToSpawn() {
        return this.toSpawn;
    }
}

