/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;

public class BarrelFluidStorage
extends SnapshotParticipant<BarrelMode>
implements SingleSlotStorage<FluidVariant> {
    public final BarrelBlockEntity barrel;

    public BarrelFluidStorage(BarrelBlockEntity barrel) {
        this.barrel = barrel;
    }

    protected void onFinalCommit() {
        this.barrel.method_5431();
    }

    public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.barrel.getMode().insertFluid(resource, maxAmount, transaction, this);
    }

    public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
        return this.barrel.getMode().extractFluid(resource, maxAmount, transaction, this);
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return this.barrel.getMode().getFluid();
    }

    public long getAmount() {
        return this.barrel.getMode().getFluidAmount();
    }

    public long getCapacity() {
        return this.barrel.getMode().getFluidCapacity();
    }

    protected BarrelMode createSnapshot() {
        return this.barrel.getMode().copy();
    }

    protected void readSnapshot(BarrelMode snapshot) {
        this.barrel.setMode(snapshot);
    }

    private void setBarrelMode(BarrelMode mode) {
        this.barrel.setMode(mode);
    }
}

