/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels;

import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlock;
import wraith.fabricaeexnihilo.modules.barrels.BarrelFluidStorage;
import wraith.fabricaeexnihilo.modules.barrels.BarrelItemStorage;
import wraith.fabricaeexnihilo.modules.barrels.modes.BarrelMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.CompostMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.EmptyMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.FluidMode;
import wraith.fabricaeexnihilo.modules.barrels.modes.ItemMode;
import wraith.fabricaeexnihilo.modules.base.BaseBlockEntity;
import wraith.fabricaeexnihilo.modules.base.EnchantableBlockEntity;
import wraith.fabricaeexnihilo.modules.base.EnchantmentContainer;
import wraith.fabricaeexnihilo.recipe.util.EntityStack;
import wraith.fabricaeexnihilo.util.CodecUtils;

public class BarrelBlockEntity
extends BaseBlockEntity
implements EnchantableBlockEntity {
    public static final class_2960 BLOCK_ENTITY_ID = FabricaeExNihilo.id("barrel");
    public static final class_2591<BarrelBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(BarrelBlockEntity::new, (class_2248[])((class_2248[])ModBlocks.BARRELS.values().toArray(new BarrelBlock[0]))).build(null);
    public final Storage<FluidVariant> fluidStorage;
    public final Storage<ItemVariant> itemStorage;
    private final EnchantmentContainer enchantments = new EnchantmentContainer();
    private BarrelMode mode = new EmptyMode();
    private int tickCounter;

    public BarrelBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
        this.itemStorage = new BarrelItemStorage(this);
        this.fluidStorage = new BarrelFluidStorage(this);
        this.tickCounter = this.field_11863 == null ? FabricaeExNihilo.CONFIG.modules.barrels.tickRate : this.field_11863.field_9229.method_43048(FabricaeExNihilo.CONFIG.modules.barrels.tickRate);
    }

    public static void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, BarrelBlockEntity barrelEntity) {
        barrelEntity.tick();
    }

    public class_1269 activate(@Nullable class_1657 player, @Nullable class_1268 hand) {
        if (this.field_11863 == null || player == null || hand == null) {
            return class_1269.field_5811;
        }
        if (this.mode instanceof ItemMode) {
            this.dropInventoryAtPlayer(player);
            return class_1269.field_5812;
        }
        if (this.mode instanceof EmptyMode || this.mode instanceof CompostMode || this.mode instanceof FluidMode) {
            return this.insertFromHand(player, hand);
        }
        return class_1269.field_5811;
    }

    public int countBelow(class_2248 block, int radius) {
        int count = 0;
        if (this.field_11863 == null) {
            return count;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (this.field_11863.method_8320(this.field_11867.method_10069(x, -1, z)).method_26204() != block) continue;
                ++count;
            }
        }
        return count;
    }

    public void dropInventoryAtPlayer(class_1657 player) {
        BarrelMode barrelMode;
        if (this.field_11863 == null || !((barrelMode = this.mode) instanceof ItemMode)) {
            return;
        }
        ItemMode itemMode = (ItemMode)barrelMode;
        class_1542 entity = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.0625, (double)this.field_11867.method_10260() + 0.5, itemMode.getStack());
        entity.method_18799(player.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(0.5));
        if (this.field_11863 != null) {
            this.field_11863.method_8649((class_1297)entity);
        }
        this.mode = new EmptyMode();
        this.method_5431();
    }

    public int getEfficiencyMultiplier() {
        return 1 + this.enchantments.getEnchantmentLevel(class_1893.field_9131);
    }

    @Override
    public EnchantmentContainer getEnchantmentContainer() {
        return this.enchantments;
    }

    public class_2338 getLeakPos() {
        if (this.field_11863 == null) {
            return null;
        }
        class_5819 rand = this.field_11863.field_9229;
        int r = FabricaeExNihilo.CONFIG.modules.barrels.leaking.radius;
        class_2338 leakPos = this.field_11867.method_10069(rand.method_43048(2 * r + 1) - r, -rand.method_43048(2), rand.method_43048(2 * r + 1) - r);
        return class_1937.method_25953((class_2338)leakPos) ? leakPos : null;
    }

    public BarrelMode getMode() {
        return this.mode;
    }

    public void setMode(BarrelMode mode) {
        this.mode = mode;
        this.method_5431();
    }

    public class_1269 insertFromHand(class_1657 player, class_1268 hand) {
        class_1799 held = player.method_5998(hand);
        if (held.method_7960()) {
            return class_1269.field_5811;
        }
        try (Transaction t = Transaction.openOuter();){
            int inserted = (int)this.itemStorage.insert((Object)ItemVariant.of((class_1799)held), (long)held.method_7947(), (TransactionContext)t);
            if (inserted != 0) {
                if (!player.method_7337()) {
                    held.method_7934(inserted);
                }
                t.commit();
                class_1269 class_12692 = class_1269.field_5812;
                return class_12692;
            }
        }
        Storage bucketFluidStorage = (Storage)FluidStorage.ITEM.find(held, (Object)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand));
        if (bucketFluidStorage == null) {
            return class_1269.field_5811;
        }
        try (Transaction t = Transaction.openOuter();){
            ResourceAmount amount = StorageUtil.findExtractableContent((Storage)bucketFluidStorage, (TransactionContext)t);
            long moved = amount == null ? StorageUtil.move(this.fluidStorage, (Storage)bucketFluidStorage, fluidVariant -> true, (long)81000L, (TransactionContext)t) : (player.method_7337() ? this.fluidStorage.insert((Object)((FluidVariant)amount.resource()), amount.amount(), (TransactionContext)t) : StorageUtil.move((Storage)bucketFluidStorage, this.fluidStorage, fluidVariant -> true, (long)81000L, (TransactionContext)t));
            if (moved != 0L) {
                t.commit();
                class_1269 class_12693 = class_1269.field_5812;
                return class_12693;
            }
        }
        return class_1269.field_5811;
    }

    public boolean isFireproof() {
        BarrelBlock barrel;
        class_2248 class_22482 = this.method_11010().method_26204();
        return class_22482 instanceof BarrelBlock && (barrel = (BarrelBlock)class_22482).isFireproof();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt == null) {
            FabricaeExNihilo.LOGGER.warn("A barrel at $pos is missing data.");
            return;
        }
        this.readNbtWithoutWorldInfo(nbt);
    }

    private void readNbtWithoutWorldInfo(class_2487 nbt) {
        this.mode = CodecUtils.fromNbt(BarrelMode.CODEC, (class_2520)nbt.method_10562("mode"));
        if (nbt.method_10545("enchantments")) {
            EnchantmentContainer readEnchantments = new EnchantmentContainer();
            readEnchantments.readNbt(nbt.method_10562("enchantments"));
            this.enchantments.setAllEnchantments(readEnchantments);
        }
    }

    public void spawnByproduct(class_1799 stack) {
        if (stack.method_7960() || this.field_11863 == null) {
            return;
        }
        class_1264.method_5449((class_1937)this.field_11863, (double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), (class_1799)stack);
    }

    public void spawnEntity(EntityStack entityStack) {
        if (entityStack.isEmpty() || this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        class_1297 entity = entityStack.getEntity((class_3218)this.field_11863, this.field_11867.method_10086((int)Math.ceil(entityStack.getType().method_17686())));
        if (entity == null) {
            return;
        }
        this.field_11863.method_8649(entity);
        entityStack.setSize(entityStack.getSize() - 1);
    }

    public void tick() {
        if (this.tickCounter <= 0) {
            this.tickCounter = FabricaeExNihilo.CONFIG.modules.barrels.tickRate;
            this.method_5431();
            this.mode.tick(this);
        } else {
            --this.tickCounter;
            this.method_5431();
        }
    }

    public void precipitationTick(class_1959.class_1963 precipitation) {
        this.mode.precipitationTick(this, precipitation);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.writeNbtWithoutWorldInfo(nbt);
    }

    private void writeNbtWithoutWorldInfo(class_2487 nbt) {
        nbt.method_10566("mode", CodecUtils.toNbt(BarrelMode.CODEC, this.mode));
        nbt.method_10566("enchantments", (class_2520)this.enchantments.writeNbt());
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((barrel, direction) -> barrel.itemStorage, TYPE);
        FluidStorage.SIDED.registerForBlockEntity((barrel, direction) -> barrel.fluidStorage, TYPE);
    }
}

