/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.compatibility.rei.sieve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import wraith.fabricaeexnihilo.recipe.SieveRecipe;
import wraith.fabricaeexnihilo.util.ItemUtils;

public class SieveRecipeHolder {
    public final boolean waterlogged;
    public final EntryIngredient input;
    public final EntryIngredient mesh;
    public final Map<EntryIngredient, List<Double>> outputs;

    public SieveRecipeHolder(EntryIngredient input, boolean waterlogged, EntryIngredient mesh, Map<EntryIngredient, List<Double>> outputs) {
        this.input = input;
        this.waterlogged = waterlogged;
        this.mesh = mesh;
        this.outputs = outputs;
    }

    public static List<SieveRecipeHolder> fromRecipe(SieveRecipe recipe) {
        ArrayList<SieveRecipeHolder> holders = new ArrayList<SieveRecipeHolder>();
        EntryIngredient output = EntryIngredients.of((class_1799)recipe.getResult());
        for (Map.Entry<class_2960, ? extends List<Double>> entry : recipe.getRolls().entrySet()) {
            holders.add(new SieveRecipeHolder(EntryIngredients.ofIngredient((class_1856)recipe.getInput()), recipe.isWaterlogged(), EntryIngredients.of((class_1935)ItemUtils.getItem(entry.getKey())), new HashMap<EntryIngredient, List<Double>>(Map.of(output, entry.getValue()))));
        }
        return holders;
    }

    public void add(SieveRecipeHolder recipe) {
        this.outputs.putAll(recipe.outputs);
    }

    public List<SieveRecipeHolder> split(int size) {
        ArrayList<SieveRecipeHolder> holders = new ArrayList<SieveRecipeHolder>();
        HashMap<Object, List<Double>> outputs = new HashMap<EntryIngredient, List<Double>>();
        int i = 0;
        Iterator<Map.Entry<EntryIngredient, List<Double>>> iterator = this.outputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<EntryIngredient, List<Double>> entry = iterator.next();
            outputs.put(entry.getKey(), entry.getValue());
            if (i >= size || !iterator.hasNext()) {
                holders.add(new SieveRecipeHolder(this.input, this.waterlogged, this.mesh, outputs));
                outputs = new HashMap();
                i = 0;
                continue;
            }
            ++i;
        }
        return holders;
    }

    public int hashCode() {
        return Objects.hash(this.input, this.waterlogged, this.mesh);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SieveRecipeHolder that = (SieveRecipeHolder)o;
        if (this.waterlogged != that.waterlogged) {
            return false;
        }
        if (!this.input.equals(that.input)) {
            return false;
        }
        return this.mesh.equals(that.mesh);
    }
}

