/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.compatibility.rei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.AlchemyCategory;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.AlchemyDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.CompostCategory;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.CompostDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.FluidCombinationCategory;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.FluidCombinationDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.LeakingCategory;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.LeakingDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.MilkingCategory;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.MilkingDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.TransformingCategory;
import wraith.fabricaeexnihilo.compatibility.rei.barrel.TransformingDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.crucible.CrucibleCategory;
import wraith.fabricaeexnihilo.compatibility.rei.crucible.CrucibleDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.crucible.CrucibleHeatCategory;
import wraith.fabricaeexnihilo.compatibility.rei.crucible.CrucibleHeatDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.sieve.SieveCategory;
import wraith.fabricaeexnihilo.compatibility.rei.sieve.SieveDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.sieve.SieveRecipeHolder;
import wraith.fabricaeexnihilo.compatibility.rei.tools.ToolCategory;
import wraith.fabricaeexnihilo.compatibility.rei.tools.ToolDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.witchwater.WitchWaterEntityCategory;
import wraith.fabricaeexnihilo.compatibility.rei.witchwater.WitchWaterEntityDisplay;
import wraith.fabricaeexnihilo.compatibility.rei.witchwater.WitchWaterWorldCategory;
import wraith.fabricaeexnihilo.compatibility.rei.witchwater.WitchWaterWorldDisplay;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.ModTools;
import wraith.fabricaeexnihilo.modules.witchwater.WitchWaterFluid;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.SieveRecipe;
import wraith.fabricaeexnihilo.recipe.ToolRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.AlchemyRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.CompostRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.FluidCombinationRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.FluidTransformationRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.LeakingRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.MilkingRecipe;
import wraith.fabricaeexnihilo.recipe.crucible.CrucibleHeatRecipe;
import wraith.fabricaeexnihilo.recipe.crucible.CrucibleRecipe;
import wraith.fabricaeexnihilo.recipe.witchwater.WitchWaterEntityRecipe;
import wraith.fabricaeexnihilo.recipe.witchwater.WitchWaterWorldRecipe;
import wraith.fabricaeexnihilo.util.ItemUtils;
import wraith.fabricaeexnihilo.util.Lazy;

public class PluginEntry
implements REIClientPlugin {
    public static final Lazy<EntryIngredient> BARRELS = new Lazy<EntryIngredient>(() -> EntryIngredient.of(ModBlocks.BARRELS.values().stream().map(EntryStacks::of).toList()));
    public static final CategoryIdentifier<AlchemyDisplay> ALCHEMY = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/barrel/alchemy"));
    public static final CategoryIdentifier<CompostDisplay> COMPOSTING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/barrel/composting"));
    public static final CategoryIdentifier<ToolDisplay> CROOK = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/tools/crook"));
    public static final CategoryIdentifier<ToolDisplay> CRUSHING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/tools/hammer"));
    public static final CategoryIdentifier<CrucibleDisplay> FIREPROOF_CRUCIBLE = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/crucible/stone"));
    public static final CategoryIdentifier<FluidCombinationDisplay> FLUID_ABOVE = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/barrel/fluid_on_top"));
    public static final CategoryIdentifier<CrucibleHeatDisplay> HEATING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/crucible/heat"));
    public static final CategoryIdentifier<LeakingDisplay> LEAKING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/barrel/leaking"));
    public static final CategoryIdentifier<MilkingDisplay> MILKING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/barrel/milking"));
    public static final CategoryIdentifier<SieveDisplay> SIFTING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/sieve"));
    public static final CategoryIdentifier<TransformingDisplay> TRANSFORMING = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/barrel/transforming"));
    public static final CategoryIdentifier<WitchWaterEntityDisplay> WITCH_WATER_ENTITY = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/witchwater/entity"));
    public static final CategoryIdentifier<WitchWaterWorldDisplay> WITCH_WATER_WORLD = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/witchwater/world"));
    public static final CategoryIdentifier<CrucibleDisplay> WOOD_CRUCIBLE = CategoryIdentifier.of((class_2960)FabricaeExNihilo.id("rei/crucible/wood"));

    public void registerCategories(CategoryRegistry registry) {
        FabricaeExNihilo.LOGGER.info("Registering REI Categories");
        registry.add((DisplayCategory)new ToolCategory(CRUSHING, ItemUtils.getExNihiloItemStack("iron_hammer"), "fabricaeexnihilo.rei.category.hammer"));
        registry.add((DisplayCategory)new ToolCategory(CROOK, ItemUtils.getExNihiloItemStack("wooden_crook"), "fabricaeexnihilo.rei.category.crook"));
        registry.add((DisplayCategory)new CrucibleCategory(WOOD_CRUCIBLE, ItemUtils.getExNihiloItemStack("oak_crucible"), "fabricaeexnihilo.rei.category.wood_crucible"));
        registry.add((DisplayCategory)new CrucibleCategory(FIREPROOF_CRUCIBLE, ItemUtils.getExNihiloItemStack("porcelain_crucible"), "fabricaeexnihilo.rei.category.porcelain_crucible"));
        registry.add((DisplayCategory)new CrucibleHeatCategory(ItemUtils.getExNihiloItemStack("porcelain_crucible"), "fabricaeexnihilo.rei.category.crucible_heat"));
        registry.add((DisplayCategory)new SieveCategory(ItemUtils.getExNihiloItemStack("oak_sieve"), "fabricaeexnihilo.rei.category.sieve"));
        registry.add((DisplayCategory)new AlchemyCategory(ItemUtils.getExNihiloItemStack("oak_barrel"), "fabricaeexnihilo.rei.category.barrel.alchemy"));
        registry.add((DisplayCategory)new TransformingCategory(ItemUtils.getExNihiloItemStack("oak_barrel"), "fabricaeexnihilo.rei.category.barrel.transforming"));
        registry.add((DisplayCategory)new CompostCategory(ItemUtils.getExNihiloItemStack("oak_barrel"), "fabricaeexnihilo.rei.category.barrel.composting"));
        registry.add((DisplayCategory)new LeakingCategory(ItemUtils.getExNihiloItemStack("oak_barrel"), "fabricaeexnihilo.rei.category.barrel.leaking"));
        registry.add((DisplayCategory)new MilkingCategory(ItemUtils.getExNihiloItemStack("oak_barrel"), "fabricaeexnihilo.rei.category.barrel.milking"));
        registry.add((DisplayCategory)new FluidCombinationCategory(ItemUtils.getExNihiloItemStack("oak_barrel"), "fabricaeexnihilo.rei.category.barrel.fluid_on_top"));
        registry.add((DisplayCategory)new WitchWaterEntityCategory());
        registry.add((DisplayCategory)new WitchWaterWorldCategory());
        ModTools.HAMMERS.values().forEach(hammer -> registry.addWorkstations(CRUSHING, new EntryStack[]{EntryStacks.of((class_1935)hammer)}));
        ModTools.CROOKS.values().forEach(crook -> registry.addWorkstations(CROOK, new EntryStack[]{EntryStacks.of((class_1935)crook)}));
        ModBlocks.CRUCIBLES.values().forEach(crucible -> {
            registry.addWorkstations(HEATING, new EntryStack[]{EntryStacks.of((class_1935)crucible)});
            if (crucible.isFireproof()) {
                registry.addWorkstations(FIREPROOF_CRUCIBLE, new EntryStack[]{EntryStacks.of((class_1935)crucible)});
            }
            registry.addWorkstations(WOOD_CRUCIBLE, new EntryStack[]{EntryStacks.of((class_1935)crucible)});
        });
        ModBlocks.SIEVES.values().forEach(sieve -> registry.addWorkstations(SIFTING, new EntryStack[]{EntryStacks.of((class_1935)sieve)}));
        ModBlocks.BARRELS.values().forEach(barrel -> {
            registry.addWorkstations(ALCHEMY, new EntryStack[]{EntryStacks.of((class_1935)barrel)});
            registry.addWorkstations(TRANSFORMING, new EntryStack[]{EntryStacks.of((class_1935)barrel)});
            registry.addWorkstations(COMPOSTING, new EntryStack[]{EntryStacks.of((class_1935)barrel)});
            if (!barrel.isFireproof()) {
                registry.addWorkstations(LEAKING, new EntryStack[]{EntryStacks.of((class_1935)barrel)});
            }
            registry.addWorkstations(MILKING, new EntryStack[]{EntryStacks.of((class_1935)barrel)});
            registry.addWorkstations(FLUID_ABOVE, new EntryStack[]{EntryStacks.of((class_1935)barrel)});
        });
        registry.addWorkstations(WITCH_WATER_ENTITY, new EntryStack[]{EntryStacks.of((class_1935)WitchWaterFluid.BUCKET)});
        registry.addWorkstations(WITCH_WATER_WORLD, new EntryStack[]{EntryStacks.of((class_1935)WitchWaterFluid.BUCKET)});
    }

    public void registerDisplays(DisplayRegistry registry) {
        FabricaeExNihilo.LOGGER.debug("Registering REI Displays");
        registry.registerRecipeFiller(ToolRecipe.class, ModRecipes.HAMMER, recipe -> new ToolDisplay((ToolRecipe)recipe, CRUSHING));
        registry.registerRecipeFiller(ToolRecipe.class, ModRecipes.CROOK, recipe -> new ToolDisplay((ToolRecipe)recipe, CROOK));
        registry.registerRecipeFiller(CrucibleRecipe.class, type -> Objects.equals(ModRecipes.CRUCIBLE, type), CrucibleRecipe::requiresFireproofCrucible, recipe -> new CrucibleDisplay((CrucibleRecipe)recipe, FIREPROOF_CRUCIBLE));
        registry.registerRecipeFiller(CrucibleRecipe.class, ModRecipes.CRUCIBLE, recipe -> new CrucibleDisplay((CrucibleRecipe)recipe, WOOD_CRUCIBLE));
        registry.registerRecipeFiller(CrucibleHeatRecipe.class, ModRecipes.CRUCIBLE_HEAT, CrucibleHeatDisplay::new);
        PluginEntry.registerSieveDisplays(registry);
        registry.registerRecipeFiller(AlchemyRecipe.class, ModRecipes.ALCHEMY, AlchemyDisplay::new);
        registry.registerRecipeFiller(FluidTransformationRecipe.class, ModRecipes.FLUID_TRANSFORMATION, TransformingDisplay::new);
        registry.registerRecipeFiller(CompostRecipe.class, ModRecipes.COMPOST, CompostDisplay::new);
        registry.registerRecipeFiller(LeakingRecipe.class, ModRecipes.LEAKING, LeakingDisplay::new);
        registry.registerRecipeFiller(MilkingRecipe.class, ModRecipes.MILKING, MilkingDisplay::new);
        registry.registerRecipeFiller(FluidCombinationRecipe.class, ModRecipes.FLUID_COMBINATION, FluidCombinationDisplay::new);
        registry.registerRecipeFiller(WitchWaterEntityRecipe.class, ModRecipes.WITCH_WATER_ENTITY, WitchWaterEntityDisplay::new);
        registry.registerRecipeFiller(WitchWaterWorldRecipe.class, ModRecipes.WITCH_WATER_WORLD, WitchWaterWorldDisplay::new);
    }

    private static void registerSieveDisplays(DisplayRegistry registry) {
        List sieveRecipes = registry.getRecipeManager().method_30027(ModRecipes.SIEVE);
        ArrayList<SieveRecipeHolder> list = new ArrayList<SieveRecipeHolder>();
        for (SieveRecipe sieveRecipe : sieveRecipes) {
            List<SieveRecipeHolder> holders = SieveRecipeHolder.fromRecipe(sieveRecipe);
            for (SieveRecipeHolder holder : holders) {
                int index = list.indexOf(holder);
                if (index == -1) {
                    list.add(holder);
                    continue;
                }
                ((SieveRecipeHolder)list.get(index)).add(holder);
            }
        }
        list.stream().flatMap(recipe -> recipe.split(27).stream()).map(SieveDisplay::new).forEachOrdered(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
    }
}

