/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.transfer.v1.client.fluid.FluidVariantRendering;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1058;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import wraith.fabricaeexnihilo.modules.crucibles.CrucibleBlockEntity;

public class CrucibleBlockEntityRenderer
implements class_827<CrucibleBlockEntity> {
    private static final float XZ_SCALE = 0.75f;
    private static final float X_MIN = 0.125f;
    private static final float X_MAX = 0.875f;
    private static final float Z_MIN = 0.125f;
    private static final float Z_MAX = 0.875f;
    private static final float Y_MIN = 0.3125f;
    private static final float Y_MAX = 0.9375f;

    public CrucibleBlockEntityRenderer(class_5614.class_5615 ctx) {
    }

    public void render(CrucibleBlockEntity crucible, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        if (crucible == null) {
            return;
        }
        FluidVariant fluid = crucible.getFluid();
        long contained = crucible.getContained();
        long queued = crucible.getQueued();
        class_1799 stack = crucible.getRenderStack();
        if (contained > 0L) {
            this.renderFluidVolume(fluid, (float)contained / (float)crucible.getMaxCapacity(), matrices, vertexConsumers, light, overlay);
        }
        if (queued > 0L && !stack.method_7960()) {
            this.renderQueued(stack, (float)queued / (float)crucible.getMaxCapacity(), matrices, vertexConsumers, light, overlay, (int)crucible.method_11016().method_10063());
        }
    }

    public void renderFluidVolume(FluidVariant fluid, float level, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1058 sprite = FluidVariantRendering.getSprite((FluidVariant)fluid);
        int color = FluidVariantRendering.getColor((FluidVariant)fluid);
        float r = (float)(color >> 16 & 0xFF) / 256.0f;
        float g = (float)(color >> 8 & 0xFF) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        if (sprite == null) {
            return;
        }
        RenderSystem.enableDepthTest();
        QuadEmitter emitter = RendererAccess.INSTANCE.getRenderer().meshBuilder().getEmitter();
        emitter.square(class_2350.field_11036, 0.125f, 0.125f, 0.875f, 0.875f, 1.0f - class_3532.method_16439((float)level, (float)0.3125f, (float)0.9375f));
        emitter.spriteBake(0, sprite, 4);
        vertexConsumers.getBuffer(class_1921.method_23583()).method_22919(matrices.method_23760(), emitter.toBakedQuad(0, sprite, false), r, g, b, light, overlay);
    }

    public void renderQueued(class_1799 renderStack, float level, class_4587 matrices, class_4597 vertexConsumer, int light, int overlay, int seed) {
        float yScale = class_3532.method_15363((float)(0.625f * level), (float)0.0f, (float)0.625f);
        matrices.method_22903();
        matrices.method_22904(0.5, (double)(0.3125f + yScale / 2.0f), 0.5);
        matrices.method_22905(0.75f, yScale, 0.75f);
        matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
        class_310.method_1551().method_1480().method_23178(renderStack, class_809.class_811.field_4315, light, overlay, matrices, vertexConsumer, seed);
        matrices.method_22909();
    }
}

