/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.gui.LanguageListWidget;
import jerozgen.languagereload.gui.LockedLanguageEntry;
import jerozgen.languagereload.gui.MovableLanguageEntry;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_426;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_426.class})
public abstract class LanguageOptionsScreenMixin
extends class_4667 {
    @Shadow
    @Final
    private static class_2561 field_26543;
    @Shadow
    @Final
    class_1076 field_2488;
    private LanguageListWidget availableLanguageList;
    private LanguageListWidget selectedLanguageList;
    private class_342 searchBox;
    private final LinkedList<class_1077> selectedLanguages = new LinkedList();
    private final Map<class_1077, MovableLanguageEntry> languageEntries = new LinkedHashMap<class_1077, MovableLanguageEntry>();
    private LockedLanguageEntry defaultLanguageEntry;

    LanguageOptionsScreenMixin(class_437 parent, class_315 options, class_2561 title) {
        super(parent, options, title);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(class_437 parent, class_315 options, class_1076 languageManager, CallbackInfo ci) {
        class_1077 currentLang = languageManager.method_4669();
        if (!currentLang.getCode().equals("en_us")) {
            this.selectedLanguages.add(currentLang);
        }
        List<class_1077> fallbacks = Config.getInstance().fallbacks.stream().map(arg_0 -> ((class_1076)languageManager).method_4668(arg_0)).filter(Objects::nonNull).toList();
        this.selectedLanguages.addAll(fallbacks);
        for (class_1077 language : languageManager.method_4665()) {
            if (!language.getCode().equals("en_us")) {
                this.languageEntries.put(language, new MovableLanguageEntry(this::refresh, language, this.selectedLanguages));
                continue;
            }
            this.defaultLanguageEntry = new LockedLanguageEntry(this::refresh, language, this.selectedLanguages);
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    void onInit(CallbackInfo ci) {
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 22, 200, 20, this.searchBox, (class_2561)class_2561.method_43473());
        this.searchBox.method_1863(__ -> this.refresh());
        this.method_25429((class_364)this.searchBox);
        this.method_20085((class_364)this.searchBox);
        int listWidth = Math.min(this.field_22789 / 2 - 4, 200);
        this.availableLanguageList = new LanguageListWidget(this.field_22787, listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"pack.available.title"));
        this.selectedLanguageList = new LanguageListWidget(this.field_22787, listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"pack.selected.title"));
        this.availableLanguageList.method_25333(this.field_22789 / 2 - 4 - listWidth);
        this.selectedLanguageList.method_25333(this.field_22789 / 2 + 4);
        this.method_25429((class_364)this.availableLanguageList);
        this.method_25429((class_364)this.selectedLanguageList);
        this.refresh();
        this.method_37063((class_364)this.field_21336.method_42437().method_18520(this.field_21336, this.field_22789 / 2 - 155, this.field_22790 - 28, 150));
        this.method_37063((class_364)new class_4185(this.field_22789 / 2 - 155 + 160, this.field_22790 - 28, 150, 20, class_5244.field_24334, this::onDone));
        super.method_25426();
        ci.cancel();
    }

    private void onDone(class_4185 button) {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.field_21335);
        Config config = Config.getInstance();
        class_1077 language = this.selectedLanguages.peekFirst();
        if (language == null) {
            language = this.field_2488.method_4668("en_us");
        }
        LinkedList fallbacks = this.selectedLanguages.stream().skip(1L).map(class_1077::getCode).collect(Collectors.toCollection(LinkedList::new));
        boolean languageIsSame = this.field_2488.method_4669().equals((Object)language);
        boolean fallbacksAreSame = config.fallbacks.equals(fallbacks);
        if (languageIsSame && fallbacksAreSame) {
            return;
        }
        config.previousLanguage = this.field_2488.method_4669().getCode();
        config.previousFallbacks = config.fallbacks;
        config.language = language.getCode();
        config.fallbacks = fallbacks;
        Config.save();
        this.field_2488.method_4667(language);
        this.field_21336.field_1883 = language.getCode();
        this.field_21336.method_1640();
        LanguageReload.reloadLanguages(this.field_22787);
    }

    private void refresh() {
        this.selectedLanguageList.method_25396().clear();
        this.selectedLanguages.forEach(language -> {
            MovableLanguageEntry entry = this.languageEntries.get(language);
            if (entry != null) {
                this.selectedLanguageList.method_25396().add(entry);
            }
        });
        this.selectedLanguageList.method_25396().add(this.defaultLanguageEntry);
        this.availableLanguageList.method_25396().clear();
        this.languageEntries.forEach((lang, entry) -> {
            if (this.selectedLanguageList.method_25396().contains(entry)) {
                return;
            }
            String langName = entry.getLanguage().toString().toLowerCase(Locale.ROOT);
            String langCode = entry.getLanguage().getCode().toLowerCase(Locale.ROOT);
            String query = this.searchBox.method_1882().toLowerCase(Locale.ROOT);
            if (langName.contains(query) || langCode.contains(query)) {
                this.availableLanguageList.method_25396().add(entry);
            }
        });
        this.availableLanguageList.method_25307(this.availableLanguageList.method_25341());
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    void onRender(class_4587 matrices, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        this.method_25434(0);
        this.availableLanguageList.method_25394(matrices, mouseX, mouseY, delta);
        this.selectedLanguageList.method_25394(matrices, mouseX, mouseY, delta);
        this.searchBox.method_25394(matrices, mouseX, mouseY, delta);
        LanguageOptionsScreenMixin.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)8, (int)0xFFFFFF);
        LanguageOptionsScreenMixin.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)field_26543, (int)(this.field_22789 / 2), (int)(this.field_22790 - 46), (int)0x808080);
        super.method_25394(matrices, mouseX, mouseY, delta);
        ci.cancel();
    }

    public void method_25393() {
        this.searchBox.method_1865();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return super.method_25404(keyCode, scanCode, modifiers) || this.searchBox.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25400(char chr, int modifiers) {
        return this.searchBox.method_25400(chr, modifiers);
    }
}

