/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util.object;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.RotatableSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.util.Utils;
import io.github.amerebagatelle.fabricskyboxes.util.object.Fade;
import io.github.amerebagatelle.fabricskyboxes.util.object.RGBA;
import io.github.amerebagatelle.fabricskyboxes.util.object.Rotation;

public class Properties {
    public static final Codec<Properties> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(Properties::getPriority), (App)Fade.CODEC.fieldOf("fade").forGetter(Properties::getFade), (App)Utils.getClampedFloat(0.0f, 1.0f).optionalFieldOf("maxAlpha", (Object)Float.valueOf(1.0f)).forGetter(Properties::getMaxAlpha), (App)Utils.getClampedFloat(0.0f, 1.0f).optionalFieldOf("transitionSpeed", (Object)Float.valueOf(1.0f)).forGetter(Properties::getTransitionSpeed), (App)Codec.BOOL.optionalFieldOf("changeFog", (Object)false).forGetter(Properties::isChangeFog), (App)RGBA.CODEC.optionalFieldOf("fogColors", (Object)RGBA.DEFAULT).forGetter(Properties::getFogColors), (App)Codec.BOOL.optionalFieldOf("sunSkyTint", (Object)true).forGetter(Properties::isRenderSunSkyTint), (App)Codec.BOOL.optionalFieldOf("shouldRotate", (Object)false).forGetter(Properties::isShouldRotate), (App)Rotation.CODEC.optionalFieldOf("rotation", (Object)Rotation.DEFAULT).forGetter(Properties::getRotation)).apply((Applicative)instance, Properties::new));
    public static final Properties DEFAULT = new Properties(0, Fade.DEFAULT, 1.0f, 1.0f, false, RGBA.DEFAULT, true, false, Rotation.DEFAULT);
    private final int priority;
    private final Fade fade;
    private final float maxAlpha;
    private final float transitionSpeed;
    private final boolean changeFog;
    private final RGBA fogColors;
    private final boolean renderSunSkyTint;
    private final boolean shouldRotate;
    private final Rotation rotation;

    public Properties(int priority, Fade fade, float maxAlpha, float transitionSpeed, boolean changeFog, RGBA fogColors, boolean renderSunSkyTint, boolean shouldRotate, Rotation rotation) {
        this.priority = priority;
        this.fade = fade;
        this.maxAlpha = maxAlpha;
        this.transitionSpeed = transitionSpeed;
        this.changeFog = changeFog;
        this.fogColors = fogColors;
        this.renderSunSkyTint = renderSunSkyTint;
        this.shouldRotate = shouldRotate;
        this.rotation = rotation;
    }

    public static Properties ofSkybox(AbstractSkybox skybox) {
        Rotation rot = Rotation.DEFAULT;
        if (skybox instanceof RotatableSkybox) {
            rot = ((RotatableSkybox)((Object)skybox)).getRotation();
        }
        return new Builder().changeFog(skybox.getProperties().isChangeFog()).renderSunSkyTint(skybox.getProperties().isRenderSunSkyTint()).shouldRotate(skybox.getProperties().isShouldRotate()).fogColors(skybox.getProperties().getFogColors()).transitionSpeed(skybox.getProperties().getTransitionSpeed()).fade(skybox.getProperties().getFade()).maxAlpha(skybox.getProperties().getMaxAlpha()).rotation(rot).build();
    }

    public int getPriority() {
        return this.priority;
    }

    public Fade getFade() {
        return this.fade;
    }

    public float getMaxAlpha() {
        return this.maxAlpha;
    }

    public float getTransitionSpeed() {
        return this.transitionSpeed;
    }

    public boolean isChangeFog() {
        return this.changeFog;
    }

    public RGBA getFogColors() {
        return this.fogColors;
    }

    public boolean isRenderSunSkyTint() {
        return this.renderSunSkyTint;
    }

    public boolean isShouldRotate() {
        return this.shouldRotate;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public static class Builder {
        private int priority = 0;
        private Fade fade = Fade.DEFAULT;
        private float maxAlpha = 1.0f;
        private float transitionSpeed = 1.0f;
        private boolean changeFog = false;
        private RGBA fogColors = RGBA.DEFAULT;
        private boolean renderSunSkyTint = true;
        private boolean shouldRotate = false;
        private Rotation rotation = Rotation.DEFAULT;

        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder fade(Fade fade) {
            this.fade = fade;
            return this;
        }

        public Builder maxAlpha(float maxAlpha) {
            this.maxAlpha = maxAlpha;
            return this;
        }

        public Builder transitionSpeed(float transitionSpeed) {
            this.transitionSpeed = transitionSpeed;
            return this;
        }

        public Builder changesFog() {
            this.changeFog = true;
            return this;
        }

        public Builder rendersSunSkyTint() {
            this.renderSunSkyTint = true;
            return this;
        }

        public Builder fogColors(RGBA fogColors) {
            this.fogColors = fogColors;
            return this;
        }

        public Builder rotation(Rotation rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder rotates() {
            this.shouldRotate = true;
            return this;
        }

        public Builder changeFog(boolean changeFog) {
            if (changeFog) {
                return this.changesFog();
            }
            return this;
        }

        public Builder renderSunSkyTint(boolean renderSunSkyTint) {
            if (renderSunSkyTint) {
                return this.rendersSunSkyTint();
            }
            return this;
        }

        public Builder shouldRotate(boolean shouldRotate) {
            if (shouldRotate) {
                return this.rotates();
            }
            return this;
        }

        public Properties build() {
            return new Properties(this.priority, this.fade, this.maxAlpha, this.transitionSpeed, this.changeFog, this.fogColors, this.renderSunSkyTint, this.shouldRotate, this.rotation);
        }
    }
}

