/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util.object;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.FabricSkyBoxesClient;
import java.util.Arrays;
import java.util.function.Consumer;

public class Blend {
    public static final Blend DEFAULT = new Blend("", 0, 0, 0);
    public static Codec<Blend> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("type", (Object)"").forGetter(Blend::getType), (App)Codec.INT.optionalFieldOf("sFactor", (Object)-1).forGetter(Blend::getSFactor), (App)Codec.INT.optionalFieldOf("dFactor", (Object)-1).forGetter(Blend::getDFactor), (App)Codec.INT.optionalFieldOf("equation", (Object)-1).forGetter(Blend::getEquation)).apply((Applicative)instance, Blend::new));
    private final String type;
    private final int sFactor;
    private final int dFactor;
    private final int equation;
    private final Consumer<Float> blendFunc;

    public Blend(String type, int sFactor, int dFactor, int equation) {
        this.type = type;
        this.sFactor = sFactor;
        this.dFactor = dFactor;
        this.equation = equation;
        if (!type.isEmpty()) {
            switch (type) {
                case "add": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "subtract": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "multiply": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue());
                    };
                    break;
                }
                case "screen": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "replace": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "alpha": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "burn": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "dodge": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Equation.ADD.value);
                        RenderSystem.setShaderColor((float)alpha.floatValue(), (float)alpha.floatValue(), (float)alpha.floatValue(), (float)1.0f);
                    };
                    break;
                }
                case "darken": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Equation.MIN.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                case "lighten": {
                    this.blendFunc = alpha -> {
                        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                        RenderSystem.blendEquation((int)Equation.MAX.value);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
                default: {
                    FabricSkyBoxesClient.getLogger().error("Blend mode is set to an invalid or unsupported value.");
                    this.blendFunc = alpha -> {
                        RenderSystem.defaultBlendFunc();
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
                    };
                    break;
                }
            }
        } else {
            this.blendFunc = this.isValidFactor(sFactor) && this.isValidFactor(dFactor) && this.isValidEquation(equation) ? alpha -> {
                RenderSystem.blendFunc((int)sFactor, (int)dFactor);
                RenderSystem.blendEquation((int)equation);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
            } : alpha -> {
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha.floatValue());
            };
        }
    }

    public void applyBlendFunc(float alpha) {
        this.blendFunc.accept(Float.valueOf(alpha));
    }

    public String getType() {
        return this.type;
    }

    public int getSFactor() {
        return this.sFactor;
    }

    public int getDFactor() {
        return this.dFactor;
    }

    public int getEquation() {
        return this.equation;
    }

    public boolean isValidFactor(int factor) {
        return Arrays.stream(GlStateManager.class_4535.values()).filter(factor1 -> factor == factor1.value).count() == 1L;
    }

    public boolean isValidEquation(int equation) {
        return Arrays.stream(Equation.values()).filter(equation1 -> equation == equation1.value).count() == 1L;
    }

    public static enum Equation {
        ADD(32774),
        SUBTRACT(32778),
        REVERSE_SUBTRACT(32779),
        MIN(32775),
        MAX(32776);

        public final int value;

        private Equation(int value) {
            this.value = value;
        }
    }
}

