/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.RGBA;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5539;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;

public class MonoColorSkybox
extends AbstractSkybox {
    public static Codec<MonoColorSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations), (App)RGBA.CODEC.optionalFieldOf("color", (Object)RGBA.DEFAULT).forGetter(MonoColorSkybox::getColor)).apply((Applicative)instance, MonoColorSkybox::new));
    public RGBA color;

    public MonoColorSkybox() {
    }

    public MonoColorSkybox(Properties properties, Conditions conditions, Decorations decorations, RGBA color) {
        super(properties, conditions, decorations);
        this.color = color;
    }

    @Override
    public SkyboxType<? extends AbstractSkybox> getType() {
        return SkyboxType.MONO_COLOR_SKYBOX;
    }

    @Override
    public void render(WorldRendererAccess worldRendererAccess, class_4587 matrices, class_1159 matrix4f, float tickDelta, class_4184 camera, boolean thickFog) {
        if (this.alpha > 0.0f) {
            RenderSystem.setShader(class_757::method_34543);
            class_310 client = class_310.method_1551();
            class_638 world = Objects.requireNonNull(client.field_1687);
            RenderSystem.disableTexture();
            class_758.method_3212();
            class_287 bufferBuilder = class_289.method_1348().method_1349();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)this.color.getRed(), (float)this.color.getGreen(), (float)this.color.getBlue(), (float)1.0f);
            worldRendererAccess.getLightSkyBuffer().method_1353();
            worldRendererAccess.getLightSkyBuffer().method_35665();
            class_291.method_1354();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] skyColor = world.method_28103().method_28109(world.method_30274(tickDelta), tickDelta);
            if (skyColor != null) {
                RenderSystem.disableTexture();
                matrices.method_22903();
                matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
                float skySide = class_3532.method_15374((float)world.method_8442(tickDelta)) < 0.0f ? 180.0f : 0.0f;
                matrices.method_22907(class_1160.field_20707.method_23214(skySide));
                matrices.method_22907(class_1160.field_20707.method_23214(90.0f));
                float skyColorRed = skyColor[0];
                float skyColorGreen = skyColor[1];
                float skyColorBlue = skyColor[2];
                class_1159 matrix4f2 = matrices.method_23760().method_23761();
                bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
                bufferBuilder.method_22918(matrix4f2, 0.0f, 100.0f, 0.0f).method_22915(skyColorRed, skyColorGreen, skyColorBlue, skyColor[3]).method_1344();
                for (int n = 0; n <= 16; ++n) {
                    float o = (float)n * ((float)Math.PI * 2) / 16.0f;
                    float p = class_3532.method_15374((float)o);
                    float q = class_3532.method_15362((float)o);
                    bufferBuilder.method_22918(matrix4f2, p * 120.0f, q * 120.0f, -q * 40.0f * skyColor[3]).method_22915(skyColor[0], skyColor[1], skyColor[2], 0.0f).method_1344();
                }
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
                matrices.method_22909();
            }
            this.renderDecorations(worldRendererAccess, matrices, matrix4f, tickDelta, bufferBuilder, this.alpha);
            RenderSystem.disableTexture();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            double d = client.field_1724.method_5836((float)tickDelta).field_1351 - world.method_28104().method_28105((class_5539)world);
            if (d < 0.0) {
                matrices.method_22903();
                matrices.method_22904(0.0, 12.0, 0.0);
                matrices.method_22909();
            }
            if (world.method_28103().method_28113()) {
                RenderSystem.setShaderColor((float)(this.color.getRed() * 0.2f + 0.04f), (float)(this.color.getBlue() * 0.2f + 0.04f), (float)(this.color.getGreen() * 0.6f + 0.1f), (float)1.0f);
            } else {
                RenderSystem.setShaderColor((float)this.color.getRed(), (float)this.color.getBlue(), (float)this.color.getGreen(), (float)1.0f);
            }
            RenderSystem.enableTexture();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public RGBA getColor() {
        return this.color;
    }
}

