/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes;

import com.google.common.collect.Range;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.amerebagatelle.fabricskyboxes.SkyboxManager;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.FSBSkybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.util.Utils;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.MinMaxEntry;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import io.github.amerebagatelle.fabricskyboxes.util.object.Weather;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_758;

public abstract class AbstractSkybox
implements FSBSkybox {
    public transient float alpha;
    protected Properties properties;
    protected Conditions conditions = Conditions.DEFAULT;
    protected Decorations decorations = Decorations.DEFAULT;

    protected AbstractSkybox() {
    }

    protected AbstractSkybox(Properties properties, Conditions conditions, Decorations decorations) {
        this.properties = properties;
        this.conditions = conditions;
        this.decorations = decorations;
    }

    private static boolean checkRanges(double value, List<MinMaxEntry> minMaxEntries) {
        return minMaxEntries.isEmpty() || minMaxEntries.stream().anyMatch(minMaxEntry -> Range.closed((Comparable)Float.valueOf(minMaxEntry.getMin()), (Comparable)Float.valueOf(minMaxEntry.getMax())).contains((Comparable)Float.valueOf((float)value)));
    }

    @Override
    public final float updateAlpha() {
        if (!this.properties.getFade().isAlwaysOn()) {
            int tempOutTime;
            int tempFullTime;
            int tempInTime;
            int currentTime = (int)(Objects.requireNonNull(class_310.method_1551().field_1687).method_8532() % 24000L);
            int durationIn = Utils.getTicksBetween(this.properties.getFade().getStartFadeIn(), this.properties.getFade().getEndFadeIn());
            int durationOut = Utils.getTicksBetween(this.properties.getFade().getStartFadeOut(), this.properties.getFade().getEndFadeOut());
            int startFadeIn = this.properties.getFade().getStartFadeIn() % 24000;
            int endFadeIn = this.properties.getFade().getEndFadeIn() % 24000;
            if (endFadeIn < startFadeIn) {
                endFadeIn += 24000;
            }
            int startFadeOut = this.properties.getFade().getStartFadeOut() % 24000;
            int endFadeOut = this.properties.getFade().getEndFadeOut() % 24000;
            if (startFadeOut < endFadeIn) {
                startFadeOut += 24000;
            }
            if (endFadeOut < startFadeOut) {
                endFadeOut += 24000;
            }
            if ((tempInTime = currentTime) < startFadeIn) {
                tempInTime += 24000;
            }
            if ((tempFullTime = currentTime) < endFadeIn) {
                tempFullTime += 24000;
            }
            if ((tempOutTime = currentTime) < startFadeOut) {
                tempOutTime += 24000;
            }
            float maxPossibleAlpha = startFadeIn < tempInTime && endFadeIn >= tempInTime ? 1.0f - (float)(endFadeIn - tempInTime) / (float)durationIn : (endFadeIn < tempFullTime && startFadeOut >= tempFullTime ? 1.0f : (startFadeOut < tempOutTime && endFadeOut >= tempOutTime ? (float)(endFadeOut - tempOutTime) / (float)durationOut : 0.0f));
            maxPossibleAlpha *= this.properties.getMaxAlpha();
            if (this.checkBiomes() && this.checkXRanges() && this.checkYRanges() && this.checkZRanges() && this.checkWeather() && this.checkEffect() && this.checkLoop()) {
                if (this.alpha >= maxPossibleAlpha) {
                    this.alpha = maxPossibleAlpha;
                } else {
                    this.alpha += this.properties.getTransitionSpeed();
                    if (this.alpha > maxPossibleAlpha) {
                        this.alpha = maxPossibleAlpha;
                    }
                }
            } else if (this.alpha > 0.0f) {
                this.alpha -= this.properties.getTransitionSpeed();
                if (this.alpha < 0.0f) {
                    this.alpha = 0.0f;
                }
            } else {
                this.alpha = 0.0f;
            }
        } else {
            this.alpha = this.checkBiomes() && this.checkXRanges() && this.checkYRanges() && this.checkZRanges() && this.checkWeather() && this.checkEffect() && this.checkLoop() ? 1.0f : 0.0f;
        }
        if (this.alpha < 0.0f) {
            this.alpha = 0.0f;
        }
        if (this.alpha > 1.0f) {
            this.alpha = 1.0f;
        }
        return this.alpha;
    }

    protected boolean checkBiomes() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        Objects.requireNonNull(client.field_1724);
        if (this.conditions.getWorlds().isEmpty() || this.conditions.getWorlds().contains(client.field_1687.method_8597().comp_655())) {
            return this.conditions.getBiomes().isEmpty() || this.conditions.getBiomes().contains(client.field_1687.method_30349().method_30530(class_2378.field_25114).method_10221((Object)((class_1959)client.field_1687.method_23753(client.field_1724.method_24515()).comp_349())));
        }
        return false;
    }

    protected boolean checkEffect() {
        class_310 client = class_310.method_1551();
        Objects.requireNonNull(client.field_1687);
        class_4184 camera = client.field_1773.method_19418();
        if (this.conditions.getEffects().isEmpty()) {
            class_1309 livingEntity;
            boolean thickFog;
            boolean bl = thickFog = client.field_1687.method_28103().method_28110(class_3532.method_15357((double)camera.method_19326().method_10216()), class_3532.method_15357((double)camera.method_19326().method_10214())) || client.field_1705.method_1740().method_1800();
            if (thickFog) {
                return false;
            }
            class_5636 cameraSubmersionType = camera.method_19334();
            if (cameraSubmersionType == class_5636.field_27887 || cameraSubmersionType == class_5636.field_27885) {
                return false;
            }
            class_1297 class_12972 = camera.method_19331();
            return !(class_12972 instanceof class_1309) || !(livingEntity = (class_1309)class_12972).method_6059(class_1294.field_5919) && !livingEntity.method_6059(class_1294.field_38092);
        }
        class_1297 class_12973 = camera.method_19331();
        if (class_12973 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12973;
            return this.conditions.getEffects().stream().noneMatch(identifier -> class_2378.field_11159.method_10223(identifier) != null && livingEntity.method_6059((class_1291)class_2378.field_11159.method_10223(identifier)));
        }
        return true;
    }

    protected boolean checkXRanges() {
        double playerX = Objects.requireNonNull(class_310.method_1551().field_1724).method_23317();
        return AbstractSkybox.checkRanges(playerX, this.conditions.getXRanges());
    }

    protected boolean checkYRanges() {
        double playerY = Objects.requireNonNull(class_310.method_1551().field_1724).method_23318();
        return AbstractSkybox.checkRanges(playerY, this.conditions.getYRanges());
    }

    protected boolean checkZRanges() {
        double playerZ = Objects.requireNonNull(class_310.method_1551().field_1724).method_23321();
        return AbstractSkybox.checkRanges(playerZ, this.conditions.getZRanges());
    }

    protected boolean checkLoop() {
        if (!this.conditions.getLoop().getRanges().isEmpty() && this.conditions.getLoop().getDays() > 0.0) {
            double currentTime;
            for (currentTime = (double)(Objects.requireNonNull(class_310.method_1551().field_1687).method_8532() - (long)this.properties.getFade().getStartFadeIn()); currentTime < 0.0; currentTime += 24000.0 * this.conditions.getLoop().getDays()) {
            }
            double currentDay = currentTime / 24000.0 % this.conditions.getLoop().getDays();
            return AbstractSkybox.checkRanges(currentDay, this.conditions.getLoop().getRanges());
        }
        return true;
    }

    protected boolean checkWeather() {
        class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
        class_746 player = Objects.requireNonNull(class_310.method_1551().field_1724);
        class_1959.class_1963 precipitation = ((class_1959)world.method_23753(player.method_24515()).comp_349()).method_8694();
        if (this.conditions.getWeathers().size() > 0) {
            if (this.conditions.getWeathers().contains((Object)Weather.THUNDER) && world.method_8546()) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.SNOW) && world.method_8419() && precipitation == class_1959.class_1963.field_9383) {
                return true;
            }
            if (this.conditions.getWeathers().contains((Object)Weather.RAIN) && world.method_8419() && !world.method_8546()) {
                return true;
            }
            return this.conditions.getWeathers().contains((Object)Weather.CLEAR) && !world.method_8419();
        }
        return true;
    }

    public abstract SkyboxType<? extends AbstractSkybox> getType();

    public void renderDecorations(WorldRendererAccess worldRendererAccess, class_4587 matrices, class_1159 matrix4f, float tickDelta, class_287 bufferBuilder, float alpha) {
        if (!SkyboxManager.getInstance().hasRenderedDecorations()) {
            class_1160 rotationStatic = this.decorations.getRotation().getStatic();
            class_1160 rotationAxis = this.decorations.getRotation().getAxis();
            RenderSystem.enableTexture();
            matrices.method_22903();
            matrices.method_22907(class_1160.field_20703.method_23214(rotationStatic.method_4943()));
            matrices.method_22907(class_1160.field_20705.method_23214(rotationStatic.method_4945()));
            matrices.method_22907(class_1160.field_20707.method_23214(rotationStatic.method_4947()));
            class_638 world = class_310.method_1551().field_1687;
            assert (world != null);
            RenderSystem.enableTexture();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            matrices.method_22907(class_1160.field_20703.method_23214(rotationAxis.method_4943()));
            matrices.method_22907(class_1160.field_20705.method_23214(rotationAxis.method_4945()));
            matrices.method_22907(class_1160.field_20707.method_23214(rotationAxis.method_4947()));
            matrices.method_22907(class_1160.field_20705.method_23214(-90.0f));
            matrices.method_22907(class_1160.field_20703.method_23214(world.method_30274(tickDelta) * 360.0f * this.decorations.getRotation().getRotationSpeed()));
            matrices.method_22907(class_1160.field_20706.method_23214(rotationAxis.method_4947()));
            matrices.method_22907(class_1160.field_20704.method_23214(rotationAxis.method_4945()));
            matrices.method_22907(class_1160.field_20702.method_23214(rotationAxis.method_4943()));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            class_1159 matrix4f2 = matrices.method_23760().method_23761();
            float s = 30.0f;
            RenderSystem.setShader(class_757::method_34542);
            if (this.decorations.isSunEnabled()) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.decorations.getSunTexture());
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                bufferBuilder.method_22918(matrix4f2, -s, 100.0f, -s).method_22913(0.0f, 0.0f).method_1344();
                bufferBuilder.method_22918(matrix4f2, s, 100.0f, -s).method_22913(1.0f, 0.0f).method_1344();
                bufferBuilder.method_22918(matrix4f2, s, 100.0f, s).method_22913(1.0f, 1.0f).method_1344();
                bufferBuilder.method_22918(matrix4f2, -s, 100.0f, s).method_22913(0.0f, 1.0f).method_1344();
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            }
            s = 20.0f;
            if (this.decorations.isMoonEnabled()) {
                RenderSystem.setShaderTexture((int)0, (class_2960)this.decorations.getMoonTexture());
                int u = world.method_30273();
                int v = u % 4;
                int w = u / 4 % 2;
                float x = (float)v / 4.0f;
                float p = (float)w / 2.0f;
                float q = (float)(v + 1) / 4.0f;
                float r = (float)(w + 1) / 2.0f;
                bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
                bufferBuilder.method_22918(matrix4f2, -s, -100.0f, s).method_22913(q, r).method_1344();
                bufferBuilder.method_22918(matrix4f2, s, -100.0f, s).method_22913(x, r).method_1344();
                bufferBuilder.method_22918(matrix4f2, s, -100.0f, -s).method_22913(x, p).method_1344();
                bufferBuilder.method_22918(matrix4f2, -s, -100.0f, -s).method_22913(q, p).method_1344();
                class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
            }
            if (this.decorations.isStarsEnabled()) {
                RenderSystem.disableTexture();
                float ab = world.method_23787(tickDelta) * s;
                if (ab > 0.0f) {
                    RenderSystem.setShaderColor((float)ab, (float)ab, (float)ab, (float)ab);
                    class_758.method_23792();
                    worldRendererAccess.getStarsBuffer().method_1353();
                    worldRendererAccess.getStarsBuffer().method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34539());
                    class_291.method_1354();
                }
            }
            matrices.method_22907(class_1160.field_20707.method_23214(rotationStatic.method_4947()));
            matrices.method_22907(class_1160.field_20705.method_23214(rotationStatic.method_4945()));
            matrices.method_22907(class_1160.field_20703.method_23214(rotationStatic.method_4943()));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            matrices.method_22909();
        }
    }

    @Override
    public Decorations getDecorations() {
        return this.decorations;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public int getPriority() {
        return this.properties.getPriority();
    }

    @Override
    public boolean isActive() {
        return (double)this.getAlpha() > 0.001;
    }

    @Override
    public boolean isActiveLater() {
        return (double)this.updateAlpha() > 0.001;
    }
}

