/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.config.Theme;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class WailaConfig
implements IWailaConfig {
    private final General general = new General();
    private final Overlay overlay = new Overlay();
    private final Formatter formatter = new Formatter();
    private int configVersion = 0;

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    @Override
    public General getGeneral() {
        return this.general;
    }

    @Override
    public Overlay getOverlay() {
        return this.overlay;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    public static class General
    implements IWailaConfig.General {
        private boolean displayTooltip = true;
        private boolean shiftForDetails = false;
        private boolean hideShiftText = false;
        private IWailaConfig.General.DisplayMode displayMode = IWailaConfig.General.DisplayMode.TOGGLE;
        private boolean hideFromPlayerList = true;
        private boolean hideFromDebug = true;
        private boolean enableTextToSpeech = false;
        private int rateLimit = 250;

        @Override
        public boolean isDisplayTooltip() {
            return this.displayTooltip;
        }

        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean isShiftForDetails() {
            return this.shiftForDetails;
        }

        public void setShiftForDetails(boolean shiftForDetails) {
            this.shiftForDetails = shiftForDetails;
        }

        @Override
        public boolean isHideShiftText() {
            return this.hideShiftText;
        }

        public void setHideShiftText(boolean hideShiftText) {
            this.hideShiftText = hideShiftText;
        }

        @Override
        public IWailaConfig.General.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        public void setDisplayMode(IWailaConfig.General.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean isHideFromPlayerList() {
            return this.hideFromPlayerList;
        }

        public void setHideFromPlayerList(boolean hideFromPlayerList) {
            this.hideFromPlayerList = hideFromPlayerList;
        }

        @Override
        public boolean isHideFromDebug() {
            return this.hideFromDebug;
        }

        public void setHideFromDebug(boolean hideFromDebug) {
            this.hideFromDebug = hideFromDebug;
        }

        @Override
        public boolean isEnableTextToSpeech() {
            return this.enableTextToSpeech;
        }

        public void setEnableTextToSpeech(boolean enableTextToSpeech) {
            this.enableTextToSpeech = enableTextToSpeech;
        }

        @Override
        public int getRateLimit() {
            this.rateLimit = Math.max(this.rateLimit, 250);
            return this.rateLimit;
        }

        public void setRateLimit(int rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        public int getMaxHealthForRender() {
            return 40;
        }

        @Override
        public int getMaxHeartsPerLine() {
            return 10;
        }
    }

    public static class Overlay
    implements IWailaConfig.Overlay {
        private final Position position = new Position();
        private final Color color = new Color();
        private float scale = 1.0f;

        @Override
        public Position getPosition() {
            return this.position;
        }

        @Override
        public float getScale() {
            return this.scale;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        @Override
        public Color getColor() {
            return this.color;
        }

        public static class Position
        implements IWailaConfig.Overlay.Position {
            private final Align align = new Align();
            private final Align anchor = new Align();
            private int x = 0;
            private int y = 0;
            private boolean bossBarsOverlap = false;

            @Override
            public int getX() {
                return this.x;
            }

            public void setX(int x) {
                this.x = x;
            }

            @Override
            public int getY() {
                return this.y;
            }

            public void setY(int y) {
                this.y = y;
            }

            @Override
            public Align getAlign() {
                return this.align;
            }

            @Override
            public Align getAnchor() {
                return this.anchor;
            }

            @Override
            public boolean isBossBarsOverlap() {
                return this.bossBarsOverlap;
            }

            public void setBossBarsOverlap(boolean bossBarsOverlap) {
                this.bossBarsOverlap = bossBarsOverlap;
            }

            public static class Align
            implements IWailaConfig.Overlay.Position.Align {
                IWailaConfig.Overlay.Position.Align.X x = IWailaConfig.Overlay.Position.Align.X.CENTER;
                IWailaConfig.Overlay.Position.Align.Y y = IWailaConfig.Overlay.Position.Align.Y.TOP;

                @Override
                public IWailaConfig.Overlay.Position.Align.X getX() {
                    return this.x;
                }

                public void setX(IWailaConfig.Overlay.Position.Align.X x) {
                    this.x = x;
                }

                @Override
                public IWailaConfig.Overlay.Position.Align.Y getY() {
                    return this.y;
                }

                public void setY(IWailaConfig.Overlay.Position.Align.Y y) {
                    this.y = y;
                }
            }
        }

        public static class Color
        implements IWailaConfig.Overlay.Color {
            private int alpha = 80;
            private Map<class_2960, Theme> themes = new HashMap<class_2960, Theme>();
            private class_2960 activeTheme = Theme.VANILLA.getId();

            public Color() {
                this.themes.put(Theme.VANILLA.getId(), Theme.VANILLA);
                this.themes.put(Theme.DARK.getId(), Theme.DARK);
            }

            @Override
            public int getAlpha() {
                return DisplayUtil.getAlphaFromPercentage(this.alpha);
            }

            public void setAlpha(int alpha) {
                this.alpha = alpha;
            }

            public int rawAlpha() {
                return this.alpha;
            }

            public Theme theme() {
                return this.themes.getOrDefault(this.activeTheme, Theme.VANILLA);
            }

            public Map<class_2960, Theme> themes() {
                return this.themes;
            }

            @Override
            public int getBackgroundColor() {
                return this.getAlpha() + this.theme().getBackgroundColor();
            }

            @Override
            public int getGradientStart() {
                return this.getAlpha() + this.theme().getGradientStart();
            }

            @Override
            public int getGradientEnd() {
                return this.getAlpha() + this.theme().getGradientEnd();
            }

            @Override
            public int getFontColor() {
                return this.theme().getFontColor();
            }

            public void applyTheme(class_2960 id) {
                this.activeTheme = this.themes.containsKey(id) ? id : this.activeTheme;
            }

            public static class Adapter
            implements JsonSerializer<Color>,
            JsonDeserializer<Color> {
                public Color deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject json = element.getAsJsonObject();
                    Color color = new Color();
                    color.alpha = json.getAsJsonPrimitive("alpha").getAsInt();
                    color.activeTheme = new class_2960(json.getAsJsonPrimitive("activeTheme").getAsString());
                    color.themes = new HashMap<class_2960, Theme>();
                    json.getAsJsonArray("themes").forEach(e -> {
                        Theme theme = (Theme)context.deserialize(e, Theme.class);
                        color.themes.put(theme.getId(), theme);
                    });
                    return color;
                }

                public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
                    JsonObject json = new JsonObject();
                    json.addProperty("alpha", (Number)src.alpha);
                    json.add("themes", context.serialize(src.themes.values()));
                    json.addProperty("activeTheme", src.activeTheme.toString());
                    return json;
                }
            }
        }
    }

    public static class Formatter
    implements IWailaConfig.Formatter {
        private String modName = "\u00a79\u00a7o%s";
        private String blockName = "\u00a7f%s";
        private String fluidName = "\u00a7f%s";
        private String entityName = "\u00a7f%s";
        private String registryName = "\u00a78%s";

        public String getModName() {
            return this.modName;
        }

        public void setModName(String modName) {
            this.modName = modName;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public void setBlockName(String blockName) {
            this.blockName = blockName;
        }

        public String getFluidName() {
            return this.fluidName;
        }

        public void setFluidName(String fluidName) {
            this.fluidName = fluidName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        public String getRegistryName() {
            return this.registryName;
        }

        public void setRegistryName(String registryName) {
            this.registryName = registryName;
        }

        @Override
        public class_2561 modName(Object modName) {
            return class_2561.method_43470((String)this.modName.formatted(modName));
        }

        @Override
        public class_2561 blockName(Object blockName) {
            return class_2561.method_43470((String)this.blockName.formatted(blockName));
        }

        @Override
        public class_2561 fluidName(Object fluidName) {
            return class_2561.method_43470((String)this.fluidName.formatted(fluidName));
        }

        @Override
        public class_2561 entityName(Object entityName) {
            return class_2561.method_43470((String)this.entityName.formatted(entityName));
        }

        @Override
        public class_2561 registryName(Object registryName) {
            return class_2561.method_43470((String)this.registryName.formatted(registryName));
        }
    }
}

