/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.culllessleaves.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.yacl.api.ConfigCategory;
import dev.isxander.yacl.api.Option;
import dev.isxander.yacl.api.OptionFlag;
import dev.isxander.yacl.api.YetAnotherConfigLib;
import dev.isxander.yacl.gui.controllers.TickBoxController;
import dev.isxander.yacl.gui.controllers.slider.IntegerSliderController;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_437;

public class CullLessLeavesConfig {
    public static final CullLessLeavesConfig INSTANCE = new CullLessLeavesConfig();
    public final Path configFile = FabricLoader.getInstance().getConfigDir().resolve("cull-less-leaves.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean enabled = true;
    public int depth = 2;

    public void save() {
        try {
            Files.deleteIfExists(this.configFile);
            JsonObject json = new JsonObject();
            json.addProperty("enabled", Boolean.valueOf(this.enabled));
            json.addProperty("depth", (Number)this.depth);
            Files.writeString(this.configFile, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            if (Files.notExists(this.configFile, new LinkOption[0])) {
                this.save();
                return;
            }
            JsonObject json = (JsonObject)this.gson.fromJson(Files.readString(this.configFile), JsonObject.class);
            if (json.has("enabled")) {
                this.enabled = json.getAsJsonPrimitive("enabled").getAsBoolean();
            }
            if (json.has("depth")) {
                this.depth = json.getAsJsonPrimitive("depth").getAsInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class_437 makeScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder().title((class_2561)class_2561.method_43471((String)"cull-less-leaves.title")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43471((String)"cull-less-leaves.title")).option(Option.createBuilder(Boolean.TYPE).name((class_2561)class_2561.method_43471((String)"cull-less-leaves.option.enabled")).binding((Object)true, () -> this.enabled, value -> {
            this.enabled = value;
        }).controller(TickBoxController::new).build()).option(Option.createBuilder(Integer.TYPE).name((class_2561)class_2561.method_43471((String)"cull-less-leaves.option.depth")).tooltip(new class_2561[]{class_2561.method_43471((String)"cull-less-leaves.option.depth.tooltip")}).binding((Object)2, () -> this.depth, value -> {
            this.depth = value;
        }).controller(yacl -> new IntegerSliderController(yacl, 1, 4, 1)).flag(new OptionFlag[]{OptionFlag.RELOAD_CHUNKS}).build()).build()).save(this::save).build().generateScreen(parent);
    }
}

