/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.lame4j;

import com.sun.jna.Pointer;
import de.maxhenkel.voicechat.lame4j.Lame;
import java.io.IOException;
import java.io.OutputStream;

public class LameEncoder
implements AutoCloseable {
    private final Pointer gfp;
    private final int channels;
    private final OutputStream outputStream;

    public LameEncoder(int channels, int sampleRate, int bitRate, int quality, OutputStream outputStream) throws IOException {
        assert (channels == 1 || channels == 2);
        assert (quality >= 0 && quality <= 9);
        this.channels = channels;
        this.outputStream = outputStream;
        this.gfp = Lame.INSTANCE.lame_init();
        Lame.INSTANCE.lame_set_num_channels(this.gfp, channels);
        Lame.INSTANCE.lame_set_in_samplerate(this.gfp, sampleRate);
        Lame.INSTANCE.lame_set_brate(this.gfp, bitRate);
        Lame.INSTANCE.lame_set_mode(this.gfp, channels == 1 ? 3 : 1);
        Lame.INSTANCE.lame_set_quality(this.gfp, quality);
        int result = Lame.INSTANCE.lame_init_params(this.gfp);
        if (result < 0) {
            throw new IOException("Failed to initialize LAME");
        }
    }

    public void write(short[] samples) throws IOException {
        assert (samples.length % this.channels == 0);
        byte[] buffer = new byte[this.estimateMp3BufferSize(samples.length) * this.channels];
        int numBytes = this.channels == 1 ? Lame.INSTANCE.lame_encode_buffer(this.gfp, samples, null, samples.length, buffer, buffer.length) : Lame.INSTANCE.lame_encode_buffer_interleaved(this.gfp, samples, samples.length / this.channels, buffer, buffer.length);
        if (numBytes < 0) {
            throw new IOException("Failed to encode samples");
        }
        this.outputStream.write(buffer, 0, numBytes);
    }

    @Override
    public void close() throws IOException {
        byte[] flushBuffer = new byte[7200];
        int numBytesFlush = Lame.INSTANCE.lame_encode_flush(this.gfp, flushBuffer, flushBuffer.length);
        this.outputStream.write(flushBuffer, 0, numBytesFlush);
        Lame.INSTANCE.lame_close(this.gfp);
        this.outputStream.close();
    }

    private int estimateMp3BufferSize(int numSamples) {
        return (int)Math.ceil(1.25 * (double)numSamples + 7200.0);
    }
}

