/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.RecordingTooltipSupplier;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    private static final class_2960 TEXTURE = new class_2960("voicechat", "textures/gui/gui_voicechat.png");
    private static final class_2960 MICROPHONE = new class_2960("voicechat", "textures/icons/microphone_button.png");
    private static final class_2960 HIDE = new class_2960("voicechat", "textures/icons/hide_button.png");
    private static final class_2960 VOLUMES = new class_2960("voicechat", "textures/icons/adjust_volumes.png");
    private static final class_2960 SPEAKER = new class_2960("voicechat", "textures/icons/speaker_button.png");
    private static final class_2960 RECORD = new class_2960("voicechat", "textures/icons/record_button.png");
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.voicechat.voice_chat.title");
    private static final class_2561 SETTINGS = class_2561.method_43471((String)"message.voicechat.settings");
    private static final class_2561 GROUP = class_2561.method_43471((String)"message.voicechat.group");
    public static final class_2561 ADJUST_PLAYER_VOLUMES = class_2561.method_43471((String)"message.voicechat.adjust_volumes");
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;
    private ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();

    public VoiceChatScreen() {
        super(TITLE, 195, 76);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        ClientVoicechat client = ClientManager.getClient();
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, this.stateManager::isMuted, button -> this.stateManager.setMuted(!this.stateManager.isMuted()), new MuteTooltipSupplier(this, this.stateManager));
        this.method_37063((class_364)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, this.stateManager::isDisabled, button -> this.stateManager.setDisabled(!this.stateManager.isDisabled()), new DisableTooltipSupplier(this, this.stateManager));
        this.method_37063((class_364)this.disable);
        ImageButton volumes = new ImageButton(this.guiLeft + 6 + 20 + 2 + 20 + 2, this.guiTop + this.ySize - 6 - 20, VOLUMES, button -> this.field_22787.method_1507((class_437)new AdjustVolumesScreen()), (button, matrices, mouseX, mouseY) -> this.method_25424(matrices, ADJUST_PLAYER_VOLUMES, mouseX, mouseY));
        this.method_37063((class_364)volumes);
        if (client != null && VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue() && (client.getRecorder() != null || client.getConnection() != null && client.getConnection().getData().allowRecording())) {
            ToggleImageButton record = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> ClientManager.getClient() != null && ClientManager.getClient().getRecorder() != null, button -> this.toggleRecording(), new RecordingTooltipSupplier(this));
            this.method_37063((class_364)record);
        }
        ToggleImageButton hide = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, VoicechatClient.CLIENT_CONFIG.hideIcons::get, button -> VoicechatClient.CLIENT_CONFIG.hideIcons.set(VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false).save(), new HideTooltipSupplier(this));
        this.method_37063((class_364)hide);
        class_4185 settings = new class_4185(this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20, SETTINGS, button -> this.field_22787.method_1507((class_437)new VoiceChatSettingsScreen()));
        this.method_37063((class_364)settings);
        class_4185 group = new class_4185(this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20, GROUP, button -> {
            if (this.stateManager.isInGroup()) {
                this.field_22787.method_1507((class_437)new GroupScreen(this.stateManager.getGroup()));
            } else {
                this.field_22787.method_1507((class_437)new JoinGroupScreen());
            }
        });
        this.method_37063((class_364)group);
        group.field_22763 = client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(72, this.ySize - 6 - 20, this.xSize - 122, 20);
        this.checkButtons();
    }

    public void method_25393() {
        super.method_25393();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.field_22763 = MuteTooltipSupplier.canMuteMic();
        this.disable.field_22763 = this.stateManager.canEnable();
    }

    private void toggleRecording() {
        ClientVoicechat c = ClientManager.getClient();
        if (c == null) {
            return;
        }
        c.toggleRecording();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == ClientCompatibilityManager.INSTANCE.getBoundKeyOf(KeyEvents.KEY_VOICE_CHAT).method_1444()) {
            this.field_22787.method_1507(null);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        this.method_25302(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float delta) {
        int titleWidth = this.field_22793.method_27525((class_5348)TITLE);
        this.field_22793.method_27528(poseStack, TITLE.method_30937(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), 0x404040);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            class_5250 time = class_2561.method_43470((String)recorder.getDuration());
            class_5250 class_52502 = time.method_27692(class_124.field_1079);
            float f = (float)(this.guiLeft + this.recordingHoverArea.getPosX()) + (float)this.recordingHoverArea.getWidth() / 2.0f - (float)this.field_22793.method_27525((class_5348)time) / 2.0f;
            float f2 = (float)(this.guiTop + this.recordingHoverArea.getPosY()) + (float)this.recordingHoverArea.getHeight() / 2.0f;
            Objects.requireNonNull(this.field_22793);
            this.field_22793.method_30883(poseStack, (class_2561)class_52502, f, f2 - 9.0f / 2.0f, 0);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                this.method_25424(poseStack, (class_2561)class_2561.method_43469((String)"message.voicechat.storage_size", (Object[])new Object[]{recorder.getStorage()}), mouseX, mouseY);
            }
        }
    }
}

