/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.config.ClientConfig;
import de.maxhenkel.voicechat.config.VolumeConfig;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.VersionCheck;
import de.maxhenkel.voicechat.profile.UsernameCache;
import de.maxhenkel.voicechat.resourcepacks.VoiceChatResourcePack;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public abstract class VoicechatClient {
    public static ClientConfig CLIENT_CONFIG;
    public static VolumeConfig VOLUME_CONFIG;
    public static UsernameCache USERNAME_CACHE;
    public static VoiceChatResourcePack CLASSIC_ICONS;
    public static VoiceChatResourcePack WHITE_ICONS;
    public static VoiceChatResourcePack BLACK_ICONS;

    public VoicechatClient() {
        KeyEvents.registerKeyBinds();
        CLASSIC_ICONS = new VoiceChatResourcePack("classic_icons", (class_2561)class_2561.method_43471((String)"resourcepack.voicechat.classic_icons"));
        WHITE_ICONS = new VoiceChatResourcePack("white_icons", (class_2561)class_2561.method_43471((String)"resourcepack.voicechat.white_icons"));
        BLACK_ICONS = new VoiceChatResourcePack("black_icons", (class_2561)class_2561.method_43471((String)"resourcepack.voicechat.black_icons"));
        ClientCompatibilityManager.INSTANCE.addResourcePackSource(class_310.method_1551().method_1520(), (consumer, packConstructor) -> {
            consumer.accept(CLASSIC_ICONS.toPack());
            consumer.accept(WHITE_ICONS.toPack());
            consumer.accept(BLACK_ICONS.toPack());
        });
    }

    public void initializeClient() {
        this.fixVolumeConfig();
        VOLUME_CONFIG = new VolumeConfig(class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties"));
        USERNAME_CACHE = new UsernameCache(class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat").resolve("username-cache.json").toFile());
        ClientManager.instance();
        if (Platform.isMac() && !VersionCheck.isMacOSNativeCompatible()) {
            Voicechat.LOGGER.warn("Your MacOS version is incompatible with {}", (Object)CommonCompatibilityManager.INSTANCE.getModName());
        }
    }

    private void fixVolumeConfig() {
        Path oldLocation = class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat-volumes.properties");
        Path newLocation = class_310.method_1551().field_1697.toPath().resolve("config").resolve("voicechat").resolve("voicechat-volumes.properties");
        if (!newLocation.toFile().exists() && oldLocation.toFile().exists()) {
            try {
                Files.move(oldLocation, newLocation, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (IOException e) {
                Voicechat.LOGGER.error("Failed to move volumes config: {}", (Object)e.getMessage());
            }
        }
    }
}

