/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b3\u00104J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u001d\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u000bJ\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0019H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b \u0010\u001cR\u001c\u0010\u0006\u001a\u00020\u00058&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010*\u001a\u00020%8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0011\u0010+\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001e\u00102\u001a\u0004\u0018\u00010-8&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00066"}, d2={"Ljuuxel/adorn/fluid/FluidReference;", "Ljuuxel/adorn/fluid/HasFluidAmount;", "Ljuuxel/adorn/fluid/FluidVolume;", "createSnapshot", "()Ljuuxel/adorn/fluid/FluidVolume;", "", "amount", "Ljuuxel/adorn/fluid/FluidUnit;", "unit", "", "decrement", "(JLjuuxel/adorn/fluid/FluidUnit;)V", "displayUnit", "Lnet/minecraft/class_2561;", "getAmountText", "(Ljuuxel/adorn/fluid/FluidUnit;)Lnet/minecraft/class_2561;", "max", "maxUnit", "(JLjuuxel/adorn/fluid/FluidUnit;Ljuuxel/adorn/fluid/FluidUnit;)Lnet/minecraft/class_2561;", "increment", "Ljuuxel/adorn/fluid/FluidIngredient;", "ingredient", "", "matches", "(Ljuuxel/adorn/fluid/FluidIngredient;)Z", "Lnet/minecraft/class_2540;", "buf", "readWithoutUnit", "(Lnet/minecraft/class_2540;)V", "", "toString", "()Ljava/lang/String;", "write", "getAmount", "()J", "setAmount", "(J)V", "Lnet/minecraft/class_3611;", "getFluid", "()Lnet/minecraft/class_3611;", "setFluid", "(Lnet/minecraft/class_3611;)V", "fluid", "isEmpty", "()Z", "Lnet/minecraft/class_2487;", "getNbt", "()Lnet/minecraft/class_2487;", "setNbt", "(Lnet/minecraft/class_2487;)V", "nbt", "<init>", "()V", "Companion", "Adorn"})
public abstract class FluidReference
implements HasFluidAmount {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract class_3611 getFluid();

    public abstract void setFluid(@NotNull class_3611 var1);

    @Override
    public abstract long getAmount();

    public abstract void setAmount(long var1);

    @Nullable
    public abstract class_2487 getNbt();

    public abstract void setNbt(@Nullable class_2487 var1);

    public final boolean isEmpty() {
        return Intrinsics.areEqual((Object)this.getFluid(), (Object)class_3612.field_15906) || this.getAmount() == 0L;
    }

    public final void write(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.method_10817((Enum)this.getUnit());
        if (this.isEmpty()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.method_10804(class_2378.field_11154.method_10206((Object)this.getFluid()));
            buf.method_10791(this.getAmount());
            buf.method_10794(this.getNbt());
        }
    }

    protected final void readWithoutUnit(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (buf.readBoolean()) {
            Object object = class_2378.field_11154.method_10200(buf.method_10816());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Registry.FLUID[buf.readVarInt()]");
            this.setFluid((class_3611)object);
            this.setAmount(buf.method_10792());
            this.setNbt(buf.method_10798());
        } else {
            class_3611 class_36112 = class_3612.field_15906;
            Intrinsics.checkNotNullExpressionValue((Object)class_36112, (String)"EMPTY");
            this.setFluid(class_36112);
            this.setAmount(0L);
            this.setNbt(null);
        }
    }

    @NotNull
    public final FluidVolume createSnapshot() {
        return new FluidVolume(this.getFluid(), this.getAmount(), this.getNbt(), this.getUnit());
    }

    public final void increment(long amount, @NotNull FluidUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.setAmount(this.getAmount() + FluidUnit.Companion.convert(amount, this.getUnit(), unit));
    }

    public final void decrement(long amount, @NotNull FluidUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.increment(-amount, unit);
    }

    public final boolean matches(@NotNull FluidIngredient ingredient) {
        Intrinsics.checkNotNullParameter((Object)ingredient, (String)"ingredient");
        return ingredient.getFluid().matches(this.getFluid()) && FluidUnit.Companion.compareVolumes(this, ingredient) >= 0 && Intrinsics.areEqual((Object)this.getNbt(), (Object)ingredient.getNbt());
    }

    @NotNull
    public final class_2561 getAmountText(@NotNull FluidUnit displayUnit) {
        Intrinsics.checkNotNullParameter((Object)displayUnit, (String)"displayUnit");
        Object[] objectArray = new Object[]{FluidUnit.Companion.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.Companion.getUnitDenominator(this.getUnit(), displayUnit)), displayUnit.getSymbol()};
        class_5250 class_52502 = class_2561.method_43469((String)"gui.adorn.fluid_volume", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(\n          \u2026playUnit.symbol\n        )");
        return (class_2561)class_52502;
    }

    public static /* synthetic */ class_2561 getAmountText$default(FluidReference fluidReference, FluidUnit fluidUnit, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAmountText");
        }
        if ((n & 1) != 0) {
            fluidUnit = FluidReference.Companion.getDefaultDisplayUnit();
        }
        return fluidReference.getAmountText(fluidUnit);
    }

    @NotNull
    public final class_2561 getAmountText(long max, @NotNull FluidUnit maxUnit, @NotNull FluidUnit displayUnit) {
        Intrinsics.checkNotNullParameter((Object)maxUnit, (String)"maxUnit");
        Intrinsics.checkNotNullParameter((Object)displayUnit, (String)"displayUnit");
        Object[] objectArray = new Object[]{FluidUnit.Companion.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.Companion.getUnitDenominator(this.getUnit(), displayUnit)), FluidUnit.Companion.losslessConvert(max, maxUnit, displayUnit).resizeFraction(FluidReference.Companion.getUnitDenominator(maxUnit, displayUnit)), displayUnit.getSymbol()};
        class_5250 class_52502 = class_2561.method_43469((String)"gui.adorn.fluid_volume.fraction", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(\n          \u2026playUnit.symbol\n        )");
        return (class_2561)class_52502;
    }

    public static /* synthetic */ class_2561 getAmountText$default(FluidReference fluidReference, long l, FluidUnit fluidUnit, FluidUnit fluidUnit2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getAmountText");
        }
        if ((n & 4) != 0) {
            fluidUnit2 = FluidReference.Companion.getDefaultDisplayUnit();
        }
        return fluidReference.getAmountText(l, fluidUnit, fluidUnit2);
    }

    @NotNull
    public String toString() {
        return "FluidReference(fluid=" + class_2378.field_11154.method_10221((Object)this.getFluid()) + ", amount=" + this.getAmount() + ", nbt=" + this.getNbt() + ")";
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0007J\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Ljuuxel/adorn/fluid/FluidReference$Companion;", "", "Ljuuxel/adorn/fluid/FluidReference;", "a", "b", "", "areFluidsAndAmountsEqual", "(Ljuuxel/adorn/fluid/FluidReference;Ljuuxel/adorn/fluid/FluidReference;)Z", "areFluidsEqual", "Ljuuxel/adorn/fluid/FluidUnit;", "getDefaultDisplayUnit", "()Ljuuxel/adorn/fluid/FluidUnit;", "from", "to", "", "getUnitDenominator", "(Ljuuxel/adorn/fluid/FluidUnit;Ljuuxel/adorn/fluid/FluidUnit;)J", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final long getUnitDenominator(FluidUnit from, FluidUnit to) {
            if (from.getBucketVolume() == to.getBucketVolume()) {
                return 1L;
            }
            return Math.max(1L, from.getBucketVolume() / to.getBucketVolume());
        }

        private final FluidUnit getDefaultDisplayUnit() {
            return ConfigManager.Companion.config().getClient().getDisplayedFluidUnit();
        }

        public final boolean areFluidsEqual(@NotNull FluidReference a, @NotNull FluidReference b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (a.isEmpty()) {
                return b.isEmpty();
            }
            return Intrinsics.areEqual((Object)a.getFluid(), (Object)b.getFluid()) && Intrinsics.areEqual((Object)a.getNbt(), (Object)b.getNbt());
        }

        public final boolean areFluidsAndAmountsEqual(@NotNull FluidReference a, @NotNull FluidReference b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            if (a.isEmpty()) {
                return b.isEmpty();
            }
            return this.areFluidsEqual(a, b) && FluidUnit.Companion.compareVolumes(a, b) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

