/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.advancementinfo;

import de.guntram.mcmod.advancementinfo.AdvancementInfo;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="advancementinfo")
public class ModConfig
implements ConfigData {
    @ConfigEntry.ColorPicker
    public int colorHave = 43520;
    @ConfigEntry.ColorPicker
    public int colorHaveNot = 0xAA0000;
    public int marginX = 30;
    public int marginY = 30;
    @ConfigEntry.Gui.CollapsibleObject
    public InfoWidth infoWidth = new InfoWidth();

    public void validatePostLoad() throws ConfigData.ValidationException {
        super.validatePostLoad();
        this.validate();
    }

    public void validate() {
        this.infoWidth.min = Math.max(100, this.infoWidth.min);
        if (this.infoWidth.min > this.infoWidth.max) {
            this.infoWidth.max = this.infoWidth.min;
        }
    }

    public static class InfoWidth {
        public int min = 120;
        public int max = 300;
        @ConfigEntry.BoundedDiscrete(min=0L, max=50L)
        public int percent = 30;

        private int clamp(int totalWidth) {
            int wantWidth = (int)((float)(totalWidth * this.percent) / 100.0f);
            return Math.max(Math.min(wantWidth, this.max), this.min);
        }

        public int calculate(int screenWidth) {
            if (this.percent == 0 || this.max == 0) {
                return 0;
            }
            return this.clamp(screenWidth - AdvancementInfo.config.marginX * 2);
        }
    }
}

