/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mixinconflicthelper.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModDependency;

public record Mod(String id, String name, List<String> conflicts, Optional<String> issuesUrl, Optional<String> sourcesUrl) {
    public static Mod fromModContainer(ModContainer mod) {
        return new Mod(mod.getMetadata().getId(), mod.getMetadata().getName(), mod.getMetadata().getDependencies().stream().filter(dep -> dep.getKind() == ModDependency.Kind.CONFLICTS).map(ModDependency::getModId).toList(), mod.getMetadata().getContact().get("issues").or(() -> mod.getMetadata().getContact().get("sources")), mod.getMetadata().getContact().get("sources"));
    }

    public static Mod fromDataInputStream(DataInputStream is) throws IOException {
        String sourcesUrl;
        String id = is.readUTF();
        String name = is.readUTF();
        int conflictSize = is.readInt();
        ArrayList<String> conflicts = new ArrayList<String>(conflictSize);
        for (int i = 0; i < conflictSize; ++i) {
            conflicts.add(is.readUTF());
        }
        String issuesUrl = is.readUTF();
        if (issuesUrl.equals("null")) {
            issuesUrl = null;
        }
        if ((sourcesUrl = is.readUTF()).equals("null")) {
            sourcesUrl = null;
        }
        return new Mod(id, name, conflicts, Optional.ofNullable(issuesUrl), Optional.ofNullable(sourcesUrl));
    }

    public void writeTo(DataOutputStream os) {
        try {
            os.writeUTF(this.id());
            os.writeUTF(this.name());
            os.writeInt(this.conflicts().size());
            for (String conflict : this.conflicts()) {
                os.writeUTF(conflict);
            }
            os.writeUTF(this.issuesUrl().orElse("null"));
            os.writeUTF(this.sourcesUrl().orElse("null"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

