/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mixinconflicthelper.gui;

import dev.isxander.mixinconflicthelper.MixinConflictHelper;
import dev.isxander.mixinconflicthelper.gui.SwingForkHelper;
import dev.isxander.mixinconflicthelper.utils.Mod;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.fabricmc.loader.api.ModContainer;

public class SwingPopups {
    public static void showConflict(ModContainer mod1Container, ModContainer mod2Container, Throwable th) throws Exception {
        Mod mod1 = Mod.fromModContainer(mod1Container);
        Mod mod2 = Mod.fromModContainer(mod2Container);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        th.printStackTrace(pw);
        String stacktrace = sw.toString();
        String issueTemplate = MixinConflictHelper.makeIssueTemplate(mod1, mod2, stacktrace);
        MixinConflictHelper.LOGGER.info("Forking JVM to display Swing GUI (bypass LWJGL)!");
        SwingForkHelper.forkSwing(mod1, mod2, issueTemplate);
    }

    public static void conflict(Mod mod1, Mod mod2, String issueTemplate) throws UnsupportedLookAndFeelException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        String message = SwingPopups.createPopupMessage(mod1, mod2);
        int option = JOptionPane.showOptionDialog(null, message, "Mixin Conflict Helper", -1, 0, null, new String[]{mod1.name(), mod2.name(), "Copy issue template"}, 0);
        switch (option) {
            case 0: {
                SwingPopups.openUrl(mod1.issuesUrl().orElseThrow());
                break;
            }
            case 1: {
                SwingPopups.openUrl(mod2.issuesUrl().orElseThrow());
                break;
            }
            case 2: {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(issueTemplate), null);
                SwingPopups.conflict(mod1, mod2, issueTemplate);
            }
        }
    }

    private static String createPopupMessage(Mod mod1, Mod mod2) {
        boolean mod1Conflicts = mod1.conflicts().stream().anyMatch(dep -> dep.equals(mod2.id()));
        boolean mod2Conflicts = mod2.conflicts().stream().anyMatch(dep -> dep.equals(mod1.id()));
        StringBuilder sb = new StringBuilder();
        sb.append("There has been a mod conflict due to Mixin.").append("\n\n");
        sb.append(mod1.name()).append(" conflicted with ").append(mod2.name()).append(". ").append("\n");
        if (mod1Conflicts || mod2Conflicts) {
            sb.append("The creator of ").append(mod1Conflicts ? mod1.name() : mod2.name()).append(" knows about the issue, so they advise you to use either mod.");
        } else {
            sb.append("To continue running the game, you should remove one of the mods.");
        }
        sb.append("\n\n");
        sb.append("Pressing the buttons below takes you to their respected issue page.");
        return sb.toString();
    }

    private static void openUrl(String url) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }
}

