/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mixinconflicthelper.gui;

import dev.isxander.mixinconflicthelper.gui.SwingPopups;
import dev.isxander.mixinconflicthelper.utils.Mod;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.SwingUtilities;

public class SwingForkHelper {
    public static void forkSwing(Mod mod1, Mod mod2, String issueTemplate) throws Exception {
        Path javaBinPath = Paths.get(System.getProperty("java.home"), "bin");
        javaBinPath = Files.exists(javaBinPath, new LinkOption[0]) ? javaBinPath.toRealPath(new LinkOption[0]) : javaBinPath.toAbsolutePath().normalize();
        String[] executables = new String[]{"javaw.exe", "java.exe", "java"};
        Path javaPath = null;
        for (String executable : executables) {
            Path path = javaBinPath.resolve(executable);
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            javaPath = path;
            break;
        }
        if (javaPath == null) {
            throw new RuntimeException("Couldn't find java executable in " + javaBinPath);
        }
        Path codeSource = Paths.get(SwingForkHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        Process process = new ProcessBuilder(javaPath.toString(), "-cp", codeSource.toString(), SwingForkHelper.class.getName()).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        try (DataOutputStream os = new DataOutputStream(process.getOutputStream());){
            mod1.writeTo(os);
            mod2.writeTo(os);
            os.writeUTF(issueTemplate);
        }
        int returnVal = process.waitFor();
        if (returnVal != 0) {
            throw new IOException("subprocess exited with code " + returnVal);
        }
    }

    public static void main(String[] args) throws Exception {
        DataInputStream is = new DataInputStream(System.in);
        Mod mod1 = Mod.fromDataInputStream(is);
        Mod mod2 = Mod.fromDataInputStream(is);
        String issueTemplate = is.readUTF();
        SwingUtilities.invokeAndWait(() -> {
            try {
                if (GraphicsEnvironment.isHeadless()) {
                    throw new HeadlessException();
                }
                System.setProperty("apple.awt.application.appearance", "system");
                System.setProperty("apple.awt.application.name", "Mixin Conflict Helper");
                SwingPopups.conflict(mod1, mod2, issueTemplate);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        System.exit(0);
    }
}

