/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mixinconflicthelper;

import dev.isxander.mixinconflicthelper.utils.Mod;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.FabricUtil;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;
import org.spongepowered.asm.mixin.transformer.ClassInfo;

public class MixinConflictHelper
implements PreLaunchEntrypoint {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mixin Conflict Helper");
    private static final Pattern MERGED_BY_REGEX = Pattern.compile("merged by ((?:[a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*)");

    public void onPreLaunch() {
        Mixins.registerErrorHandlerClass((String)"dev.isxander.mixinconflicthelper.ConflictErrorHandler");
    }

    public static Optional<ModContainer> getModForMixinConfig(IMixinConfig mixinConfig) {
        return FabricLoader.getInstance().getModContainer(FabricUtil.getModId((IMixinConfig)mixinConfig));
    }

    public static Optional<ModContainer> walkExceptionCauseForMerger(Throwable th) {
        try {
            for (Throwable throwable = th; throwable != null; throwable = throwable.getCause()) {
                if (!(throwable instanceof InvalidInjectionException)) continue;
                InvalidInjectionException injectionException = (InvalidInjectionException)throwable;
                ISelectorContext iSelectorContext = injectionException.getContext();
                if (iSelectorContext instanceof InjectionInfo) {
                    InjectionInfo injectionInfo = (InjectionInfo)iSelectorContext;
                    ClassInfo classInfo = ClassInfo.fromCache((String)injectionInfo.getMixin().getTargetClassRef());
                    Field mixinsField = ClassInfo.class.getDeclaredField("mixins");
                    mixinsField.setAccessible(true);
                    Set mixins = (Set)mixinsField.get(classInfo);
                    Matcher matcher = MERGED_BY_REGEX.matcher(injectionException.getMessage());
                    boolean found = matcher.find();
                    if (found) {
                        String mergerMixinClass = matcher.group(1);
                        for (IMixinInfo mixin : mixins) {
                            if (!mixin.getClassName().equals(mergerMixinClass)) continue;
                            return MixinConflictHelper.getModForMixinConfig(mixin.getConfig());
                        }
                    }
                }
                break;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NullPointerException | SecurityException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    public static String makeIssueTemplate(Mod mod1, Mod mod2, String stacktrace) {
        StringBuilder modListBuilder = new StringBuilder();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            if (!modListBuilder.isEmpty()) {
                modListBuilder.append("\n");
            }
            modListBuilder.append("- ");
            modListBuilder.append(meta.getId());
            modListBuilder.append(" ");
            modListBuilder.append(meta.getVersion().getFriendlyString());
            mod.getContainingMod().ifPresent(parent -> {
                modListBuilder.append(" via ");
                modListBuilder.append(parent.getMetadata().getId());
            });
        }
        return "[%s](%s) is conflicting with [%s](%s).\n\n## Stacktrace\n```\n%s\n```\n\n## Mod list\n```\n%s\n```\n\n## Game info\nMinecraft Version: %s\n%s Version: %s\n\n*Message autogenerated using [MixinConflictHelper](https://github.com/isXander/MixinConflictHelper)*\n".stripIndent().formatted(mod1.name(), mod1.sourcesUrl().orElse("#"), mod2.name(), mod2.sourcesUrl().orElse("#"), stacktrace, modListBuilder.toString(), ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").orElseThrow()).getMetadata().getVersion().getFriendlyString(), ((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").orElseThrow()).getMetadata().getName(), ((ModContainer)FabricLoader.getInstance().getModContainer("fabricloader").orElseThrow()).getMetadata().getVersion());
    }
}

