/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.mixinconflicthelper;

import dev.isxander.mixinconflicthelper.MixinConflictHelper;
import dev.isxander.mixinconflicthelper.exception.MixinConflictException;
import dev.isxander.mixinconflicthelper.gui.SwingPopups;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ConflictErrorHandler
implements IMixinErrorHandler {
    public IMixinErrorHandler.ErrorAction onPrepareError(IMixinConfig config, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        return action;
    }

    public IMixinErrorHandler.ErrorAction onApplyError(String targetClassName, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        Optional<ModContainer> mod1 = MixinConflictHelper.getModForMixinConfig(mixin.getConfig());
        Optional<ModContainer> mod2 = MixinConflictHelper.walkExceptionCauseForMerger(th);
        if (mod1.isPresent() && mod2.isPresent()) {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                try {
                    SwingPopups.showConflict(mod1.get(), mod2.get(), th);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new MixinConflictException(String.format("%s tried to inject into code already modified by %s", mod1.get().getMetadata().getName(), mod2.get().getMetadata().getName()), th);
            }
        }
        return action;
    }
}

